import java.util.concurrent.locks.ReentrantLock;

public class Prodavnica extends Thread {
	private int stanje;
	private final int limit = 1000;
	private Skladiste skladiste;
	private ReentrantLock lock;

	public Prodavnica(Skladiste skladiste, ReentrantLock lock) {
		/*
		 * na pocetku prodavnice su prazne i uzimaju cokoladice iz skladista
		 */
		this.stanje = 0;
		this.skladiste = skladiste;
		this.lock = lock;
	}

	public int getBrojCokoladica() {
		return stanje;
	}

	public void setBrojCokoladica(int n) {
		this.stanje = n;
	}

	@Override
	public void run() {
		while (true) {
			try {
				/*
				 * ako prodavnica nije puna, uzima dodatne cokoladice iz
				 * skladista
				 */
				if (stanje < limit) {
					lock.lock();
					skladiste.setStanje(skladiste.getStanje()
							- (limit - stanje));
					stanje = limit;
					lock.unlock();
				}

				/*
				 * cekamo 5 sekundi do naredne dopune
				 */
				Thread.sleep(5000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public String toString() {
		return "Cokoladica u prodavnici: " + stanje + "\n";
	}
}
