import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class GUI extends JFrame {

    private int w = 600;
    private int h = 500;

    public GUI() {
        setPreferredSize(new Dimension(w, h)); /*
         * sugerismo swing-u koja je
         * dimenzija frame-a
         */
        addComponents();
        setVisible(true); // inicijalno je frame nevidljiv
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        center();
        pack(); /*
         * komanda koja sve sto smo podesili primenjuje (obavezno
         * pozvati)
         */
    }

    private void addComponents() {
        Panel panel = new Panel(500, 500);
        getContentPane().add(panel);
    }

    private void center() {
        /*
         * centriramo nas okvir, inicijalno se postavlja u gornji levi ugao
         * ekrana
         */
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int) (d.getWidth() - w) / 2;
        int y = (int) (d.getHeight() - h) / 2;
        setLocation(new Point(x, y));
    }

    public static void main(String[] args) {
        GUI gui = new GUI();
    }
}


