#include<iostream>
#include<string>
#include<list>

using namespace std;

class Cipela{

	public:
		Cipela(const string &model, const string &boja, double stikla){
			_model = model;
			_boja = boja;
			_stikla = stikla;
		}
		string Model() const{
			return _model;
		}
		string Boja() const{
			return _boja;
		}
		double Stikla() const{
			return _stikla;
		}
	private:
		string _model;
		string _boja;
		double _stikla;
};


class Odgovarajuce{
	
	public:
		Odgovarajuce(const string &boja, double stikla){
			_boja = boja;
			if(stikla < 0)
				_stikla = 5;
			else
				_stikla = stikla;
		}
                // provera da li cipela zadovoljava kriterijume kupovine
		bool operator () (const Cipela &c) const{
			return c.Boja() == _boja && c.Stikla() <= _stikla;
		}

	private:
		string _boja;
		double _stikla;
};

template <typename Kol, typename Fun>
void odredi(Kol &k, const Fun &f){
	typename Kol::iterator it;
	for(it=k.begin();it!=k.end();){
                // ukoliko f vrati false, cipela se brise
                // inace ostaje u kolekciji
		if(!f(*it))
			it = k.erase(it);
		else
			it++;
	}
	
}

int main(){
        // koristimo listu jer je potrebna operacija brisanja iz proizvoljnog dela kolekcije
	list<Cipela> cipele;
	int i, n, stikla;
	string boja, model;
	cin >> n;
	for(i=0;i<n;i++){
		cin >> model >> stikla >> boja;
		cipele.push_back(Cipela(model, boja, stikla)); 	
	}

	cin >> stikla >> boja;
	Odgovarajuce f(boja, stikla); 
	odredi(cipele, f);
        // ukoliko je nakon modifikacije kolekcije ostala neka cipela, ispisujemo modele
        // inace, ispisujemo odgovarajucu poruku 
	if(cipele.size()!=0){
		list<Cipela>::const_iterator it;
		for(it=cipele.begin();it!=cipele.end();it++)
			cout << it->Model() << endl;
	}
	else
		cout << "Nema trazenih modela" << endl;		
	
	
	

}
