#include<iostream>
#include<map>
#include<string>

using namespace std;

class Povoljno{
	public:
		Povoljno(int cena){
			if(cena > 0)
				_cena = cena;
			else
				_cena = 1000;		
		}
                // argument je cena po nocenju za odredjenu ponudu agencije
                // proveravamo da li je budzet dovoljan za devet nocenja (desetodnevno letovanje)
		bool operator () (int cena) const{
			return _cena >= cena*9;
		}
	private:
		int _cena;
};


template <typename Kol, typename Fun>
void povoljni(const Kol &k, const Fun &f){
	typename Kol::const_iterator it;
	int ima = 0;
	for(it=k.begin();it!=k.end();it++)
		if(f(it->first)){
			ima = 1;
			cout << it->second[0] << " " << it->second[1] << endl;		
		}
	if(ima==0)
		cout << "Nema povoljnih ponuda" << endl;
			
}

int main(){
        // cena po nocenju je jedinstveni podatak pa je koristimo kao kljuc mape
        // ceni su pridruzena dva stringa - naziv agencije i destinacije letovanja
	map<int, string*> ponude;
	int i, n, cena;
	cin >> n;
	string *niz;
	for(i=0;i<n;i++){
                // za svaku novu ponudu pravimo novi niz od dva stringa
		niz = new string[2];
		cin >> niz[0] >> niz[1] >> cena;
                // ceni pridruzujemo pokazivac na dinamicki alociran niz stringova sa informacijama o letovanju
		ponude[cena] = niz;
	}

	map<int, string*>::const_iterator it;
	for(it=ponude.begin();it!=ponude.end();it++)
		cout << it->second[0] << " " << it->second[1] << " " << it->first << endl;
	
	cin >> cena;
	Povoljno f(cena);
	povoljni(ponude, f);

}
