#include<iostream>
#include<string>
#include<vector>
#include<cstdlib>

using namespace std;

class Duel{

	public:
		Duel(const string &domacin, const string &gost, int golDomacin, int golGost){
			_domacin = domacin;
			_gost = gost;
			_golDomacin = golDomacin;
			_golGost = golGost;
		}
		string domacin() const{
			return _domacin;
		}
		string gost() const{
			return _gost;
		}
		int golDomacin() const{
			return _golDomacin;
		}
		int golGost() const{
			return _golGost;
		}
	private:
		string _domacin;
		string _gost;
		int _golDomacin;
		int _golGost;

};


class Gol{
	
	public:
		Gol(int golRazlika){
			if(golRazlika < 0)
				_golRazlika = 2;
			else
				_golRazlika = golRazlika;
		}
                // provera da li Duel ima trazenu gol razliku
		bool operator () (const Duel &d) const{
			return abs(d.golGost() - d.golDomacin()) == _golRazlika;
		}

	private:
		int _golRazlika;
};

template <typename Kol, typename Fun>
void odredi(const Kol &k, const Fun &f){
	typename Kol::const_iterator it;
        int ima = 0;
	for(it=k.begin();it!=k.end();it++){
                // ukoliko f vrati true, Duel je bio sa trazenom gol razlikom
		if(f(*it)){
			ima = 1;
			cout << it->domacin() << " " << it->gost() << endl;
		}
	}
	if(ima == 0)
		cout << "Nema trazenih duela" << endl;
	
}

int main(){
        // koristimo vektor jer nisu potrebne operacije brisanja i umetanja u proizvoljan deo kolekcije
	vector<Duel> dueli;
	int i, n, golDomacin, golGost, golRazlika;
	string gost, domacin;
	cin >> n;
	for(i=0;i<n;i++){
		cin >> domacin >> gost >> golDomacin >> golGost;
		dueli.push_back(Duel(domacin, gost, golDomacin, golGost)); 	
	}

	cin >> golRazlika;
	Gol f(golRazlika); 
	odredi(dueli, f);
}
