#ifndef KUPA_H
#define KUPA_H

#include<iostream>
#include<cmath>  // zbog M_PI i fabs koji ce se koristiti u main-u

namespace obrtnaTela{

	template <typename T>
	class PravaKupa{

		public:
			PravaKupa(const T &r, const T &H){
				_r = r;
				_H = H;
			}
			T zapremina() const{
				return _r*_r*M_PI*_H/3;			
			}
			bool operator < (const PravaKupa &k) const{
				return zapremina() < k.zapremina();
			}
			bool operator == (const PravaKupa &k) const{
				return zapremina() == k.zapremina();
			}

		private:
			T _r;
			T _H;
			
	};


}

#endif
