#include <iostream>

/* Sabloni funkcija omogucavaju da se definicija funkcije parametrizuje
 n ekim tipom, ili tipovima. Na ovaj nacin se *jednom definicijom zapravo
 definise citava familija funkcija, za razlicite vrednosti tipskih 
 parametara. Sabloni funkcija imaju sledecu sintaksu:
 
 template <lista_tipskih_parametara> definicija_funkcije
 
 Kljucnom recju template pocinje definicija sablona. Nakon toga u 
 zagradama < > sledi neprazna lista tipskih parametara razdvojenih
 zarezima, pri cemu svaki tipski parametar ima oblik:
 
 typename T
 
 ili 
 
 class T
 
 gde je typename odnosno class kljucna rec (potpuno je svejedno koju cete
 koristiti, ista je semantika u ovom kontekstu), a T je proizvoljan 
 identifikator (naravno, ako ima vise parametara, svi moraju imati
 razlicite identifikatore). Definicija funkcije moze biti proizvoljna,
 kao i kod obicnih funkcija, s tim sto se navedeni tipski parametri 
 sablona mogu koristiti bilo gde gde se ocekuje tip (npr, u povratnom
 tipu, tipovima parametara funkcije, tipovima lokalnih promenljivih).
 
 Kada se ovako definisana funkcija (zapravo sablon funkcija) pozove, 
 tada se na osnovu stvarnih tipova argumenata poziva vrsi tzv. 
 "dedukcija tipova parametara sablona", sto znaci da se parametrima sablona
 dodeljuju odgovarajuci tipovi, ako je to moguce. Nakon uspesne dedukcije,
 dolazi do "instanciranja sablona", tj. do kreiranja konkretne funkcije koja
 nastaje iz sablona tako sto se svaka pojava nekog tipskog parametra 
 zamenjuje odgovarajucim konkretnim tipom. */

/* sablon za odredjivanje maksimuma je mogao da se definise i kao 

template <typename T>
const T maksimum(const T x, const T y){
	return x > y ? x : y;
} 

iako ovo ne pravi bitnu razliku kada se instancira sablon za primitivan tip T, 
ako bi T bio klasni tip, tada bi se kopirali citavi objekti u lokalne promenljive
za funkciju sto je svakako neefikasno, pa se zbog toga preporucuje da sablon kao
argumente ima reference 

*/

template <typename T>
T maksimum(const T& x, const T& y){
	return x > y ? x : y;
}

/* Korak je opcioni argument, sto daje mogucnost da se sablonska funkcija pozove sa samo dva argumenta pri cemu se koristi podrazumevana vrednost za korak */ 
template <typename T>
void ispisIntervala( const T& x, const T& y, T korak=1 ){
	for( T i = x; i <= y; i+=korak )
		std::cout << i << ' ';
	std::cout << '\n';
}

int main(){

	int x, y;
	std::cout << "Unesite dva cela broja "<< std::endl;
	std::cin >> x >> y;

// Instanciranje sablona za T = int.
	std::cout <<"Maksimum je: "<< maksimum(x, y) << std::endl;

	double a, b;
	std::cout << "Unesite dva realna broja "<< std::endl;
	std::cin >> a >> b;
  
// Instanciranje sablona za T = double.
	std::cout <<"Maksimum je: "<< maksimum(a, b) << std::endl;

	/* Ovo ne radi: dedukcija tipova nece uspeti, jer je na prvom argument int, a na 	drugom double. 
	 Prilikom dedukcije tipova prevodilac ne dozvoljava konverzije, tj. ne moze se *zakljucti da je T = int na osnovu prvog argumenta,
	 pa da se onda drugi konveruje iz double u int, ili obrnuto. Prevodilac prijavljuje gresku za:
	 cout << maksimum(x, b) << endl;
	 
	 Da bismo razresili gornji problem, ekplicitno navodimo koji tip hocemo da koristimo za T. 
	 Nakon sto se instancira sablon za T = double, poziva se taj primerak, pri cemu se prvi argument (koji je tipa int)
	 konvertuje u double (konverzije su zabranjene samo u toku dedukcije tipova) */
	std::cout << "Maksimum je: "<< maksimum<double>(x, b) << std::endl;
/* Ispisuje interval za karaktere, konverzija je neophodna da bi mogao da se koristi skraceni zapis sablona */
	ispisIntervala( 'a', 'e', (char)2 );
//Puna sintaksa, nije potrebno vrsiti konverziju dvojke u char
	ispisIntervala<char>( 'a', 'e', 2 );
	ispisIntervala( 23.4, 27.8, 0.2 );
//Koristi se podrazumevana vrednost za korak
	ispisIntervala( 23, 27);
 
}
