#ifndef TROUGAO_H
#define TROUGAO_H  
#include <iostream>
#include <cmath>

namespace geometrija{

	/* Klasa se definise na sledeci nacin:
	  
	    struct ImeKlase {
	  
	    // clanovi klase 
	  
	 };
	 
	 ili
	 
	 class ImeKlase {
		 
		 // clanovi klase
		 
	 };
	 
	 Opciono, definicija klase moze sadrzati i specifikatore prava pristupa. Svaki clan kase moze biti javan (public), zasticen (protected) ili privatan (private). Specifikator public znaci da se clanu klase moze pristupiti iz bilo koje funkcije u programu. Specifikator private znaci da se clanu klase moze pristupiti samo iz funkcija clanica te klase. Specifikator protected znaci da se clanu klase moze pristupiti iz funkcija clanica te klase i klasa koje je nasladjuju. Svaki specifikator klase se primenjuje na sve clanove klase koje slede neposredno iza njega, sve do sledeceg specifikatora (ako postoji) ili do kraja definicije klase.
	 
	 Razlika izmedju koriscenja kljucne reci struct (koja je nasledjena iz C-a) i kljucne reci class je jedino u tretiranju clanova klase koji se nalaze na pocetku definicije klase, pre prvog specifikatora: u slucaju kljucne reci struct, ovi clanovi ce biti javni (tj. sve je javno, ako se ne kaze drugacije, sto je kompatibilno sa C-om), dok u slucaju kljucne reci class ovi clanovi ce biti privatni (tj. sve je privatno, ako se ne kaze drugacije). */
	
/* Primer klase Trougao */
class Trougao {
	/* Funkcije clanice klase su obicno javne. Ovim se obezbedjuje javni
	 "interfejs" pomocu *koga drugi delovi programa mogu da pristupaju
	 objektima klase. */
public:
	/* Specijalne metode zvane "konstruktori" sluze za inicijalizaciju objekata
	 k lasnog tipa. K*onstruktori se uvek zovu isto kao i sama klasa, nemaju
	 povratni tip (cak ni void) i mogu se preklapati, kao i sve ostale funkcije
	 (tj. klasa moze imati vise konstruktora sa razlicitim listama parametara).
	 Konstruktor se poziva automatski prilikom kreiranja objekta, npr:
	 
	 Trougao t(2, 4, 5);
	 
	 Konstruktor koji nema argumente zove se "podrazumevani konstruktor". Ovaj
	 konstruktor se poziva kada se objekat kreira bez argumenata konstrukcije:
	 
	 Trougao t;
	 
	 Ukoliko programer ne definise konstruktor, tada prevodilac 
	 automatski kreira tzv. "implicitni podrazumevani konstruktor" koji 
	 ne radi nista. Ukoliko programer definise bar jedan konstruktor, tada
	 prevodilac ne kreira implicitni konstruktor -- ukoliko u tom slucaju 
	 programer zeli da ima i podrazumevani konstruktor, mora sam eksplicitno da 
	 ga definise */ 
	Trougao();
	Trougao(double a, double b, double c);
	/* Metode za pristup odgovarajucim podacima */
	double vratiA() const;
	double vratiB() const;
	double vratiC() const;
	static bool provera(double a, double b, double c);
	void postavi(double a, double b, double c);
	double obim() const;
	double povrsina() const;
	double poluprecnikUpisanog() const;
	double poluprecnikOpisanog() const;
	bool imaVeciObimOd(const Trougao & t) const;
	/* postoji mogucnost redefinisanja operatora, u nasem primeru, trouglove poredimo po povrsini kada koristimo operatore <, ==, > */
	bool operator < ( const Trougao& t ) const;
	bool operator == ( const Trougao& t ) const;
	bool operator > ( const Trougao& t ) const;
	/* operator sabiranja vraca trougao ciji su elementi dobijeni sabiranjem odgovarajucih elemenata trouglova operanada */
	Trougao operator + ( const Trougao& t ) const;

	/* Podaci clanovi klase su obicno privatni. Ovim se vrsi "skrivanje"
	 i mplementacije klase, sto je uobicajena praksa u objektno orijentisanom*
	 programiranju. U ovom slucaju, u pitanju su duzine stranica trougla. */
private:
	double _a;
	double _b;
	double _c;

};

std::ostream& operator << (std::ostream& ostr, const Trougao& t);
std::istream& operator >> (std::istream& istr, Trougao& t);
}

#endif
