#include<iostream>
#include<map>
#include<string>
#include<algorithm>

using std::cout;
using std::cin;
using std::endl;

/* 
	template <class InputIterator, class Function>
   	Function for_each (InputIterator first, InputIterator last, Function fn);

Sablon for_each iz biblioteke algorithm primenjuje funkciju fn na sve elemente na koje pokazuju iteratori iz ranga [first, last).
Fn moze biti funkcijski pokazivac ili funkcional (funkcijski objekat) koji za argument ima element na koji pokazuje itarator iz ranga [first, last). Povratna vrednost ove funkcije se ignorise, ukoliko postoji.
 
*/


/* funkcija akcija kao argument ima element nase kolekcije, tj. podatke o jednom artiklu */
void akcija(std::pair<std::string, double*> artikal){
	// artikal.second[0] je raspoloziva kolicina
	// artikal.second[1] je cena artikla
	// smanjujemo cenu za 10% 
	artikal.second[1] *= 0.9;	

}

/* implementacija sablona for_each, kao povratnu vrednost ima funkciju koju dobija kao argument */
template<class Iterator, class Funkcija>
Funkcija klon_for_each(Iterator pocetak, Iterator kraj, Funkcija f){
	while(pocetak!=kraj){
		// primenjujemo funkciju na tekuci element
		f(*pocetak); 
		// pomeramo se na sledeci element iz ranga
		++pocetak;
	}
	
	return f;
}

int main(){
	
	int n; 
	cout<<"Unesite koliko vrsta artikala ima prodavnica:"<<endl;
	cin>>n;
	/* Mapa prodavnica kao kljuc ima ime artikla, a kao
	vrednost dvoclani niz za podatke o kolicini i ceni. */
	std::map<std::string, double*> prodavnica;
	cout<<"Unesite podatke o artiklima (ime, kolicina, cena):"<<endl;
	for(int i=0;i<n;i++){
			std::string ime;
			double *podaci = new double[2];
			cin >> ime >> podaci[0] >> podaci[1];
			prodavnica.insert(make_pair(ime, podaci));
	}
	std::map<std::string, double*>::const_iterator it;  
	cout << "Raspolozivi artikli:" << endl;
	for(it = prodavnica.begin(); it!=prodavnica.end(); it++)
		cout << "Artikal: " << it->first << ", komada na stanju: "<< it->second[0] << ", cena: " << it->second[1] << endl;
	// upotreba sablona for_each iz biblioteke algorithm:
	// std::for_each(prodavnica.begin(), prodavnica.end(), akcija);

	klon_for_each(prodavnica.begin(), prodavnica.end(), akcija);
	cout << "Raspolozivi artikli - akcijske cene:" << endl;
	for(it = prodavnica.begin(); it!=prodavnica.end(); it++)
		cout << "Artikal: " << it->first << ", komada na stanju: "<< it->second[0] << ", cena: " << it->second[1] << endl;

}
