import pandas

# Series predstavlja 1D – jednodimenzionalni objekat slicno koloni u tabeli 
# ima mogucnost da skladisti bilo koji tip podataka gde dodeljuje index svakoj vrednosti 
# podrazumevano, svaka vrednost će dobiti index od 0 do N (gde je N veličina serije - 1).
# primer:
# s1 = pandas.Series(['Dusan','Tomic','Beograd',24])
# print(s1)
# svakom elementu se moze pristupiti preko indeksa
# print(s1[3])

# ukoliko zelimo da promenimo podrazumevano indeksiranje 
# listu indeksa prosledjujemo kao drugi argument
s = pandas.Series([1, 2, 3, 4, 5],[1, 2, 3, 4, 5])
print(s)
print(s[4])

# Napomena: indeksi ne moraju biti jedinstveni
# primer:
# s3 = pandas.Series([1, 2, 3, 4, 5],[1, 1, 1, 4, 5])
# print(s3)
# print(s3[1])

# seriji se moze dodeliti ime
s.name = 'brojevi'
print(s)

# izvlacenje podserije sa iloc (integer-location based indexing)
# argumenti imaju znacenje kao kod slice operatora za liste
print(s.iloc[:3])

# pravljenje nove serije od postojece 
# na svaki element se doda 2
s_add2 = s.add(2)
print(s_add2)
# svaki element se pomnozi sa 2
print(s.mul(2))
# moze se proslediti i lista brojeva kojim se mnoze brojevi iz serije redom
print(s.mul([1,2,3,4,5]))

# unarna funkcija
def f(x):
    return 2*x + 1
# unarna funkcija se primeni na svaki element serije
s = s.apply(f)
print(s)