import pandas

# DataFrame predstavlja tabelarnu strukturu podataka koja je definisana kao 2D
# dvodimenzionalna struktura sa kolonama u redovima sa potencijalno razlicitim tipovima podataka 
#
# DataFrame se sastoji od tri glavne komponente:
# - podataka (Pandas DataFrame ili Series, itd…)
# - index-a
# - kolona

# DataFrame se moze napraviti od recnika
# serije koje cemo koristiti u recniku 
s1 = pandas.Series(range(1, 11), name='osnova')

# recnik
d = {s1.name: s1}
df = pandas.DataFrame(d)
print(df)

# dodavanje nove kolone indeksnim pristupom 
df['kvadrat'] = df['osnova'] ** 2
print(df)

def kub(x):
    return x ** 3

# dodavanje nove kolone preko funkcije assign 
# argument je u obliku ime_nove_kolone = kolona_vrednosti 
df = df.assign(kub = kub(df['osnova']))
print(df)

# filtriranje podataka 
# rezultat je DataFrame objekat
# vrste u kojima je kvadrat deljiv sa 3
f1 = df.query('kvadrat % 3 != 0')
print(f1)

# vrste u kojima je kub paran
f2 = df.query('kub % 2 == 0')
print(f2)

# kombinovanje uslova
f3 = df.query('kub % 2 == 0 & kvadrat % 3 != 0')
print(f3)

# eksportovanje rezultata u csv datoteku
f3.to_csv('rezultat.csv')
