import constraint

problem = constraint.Problem()
# Definisemo promenljive za svaki novcic
# ako bi se zahtevalo da u kombinaciji bude od svake vrednosti
# bar po jedan novcic samo treba promeniti da domen za svaku
# promenljivu krece od 1
problem.addVariable("1 din",range(0,51))
problem.addVariable("2 din",range(0,26))
problem.addVariable("5 din",range(0,11))
problem.addVariable("10 din",range(0,6))
problem.addVariable("20 din",range(0,3))

# I nacin je koriscenje ExactSumConstraint ogranicenja
# pri cemu je potrebno proslediti i listu koeficijenata 
# kojim treba da se mnoze odgovarajuce promenljive
# jer zelimo da se proveri uslov za sledecu linearnu kombinaciju:
# a + 2*b + 5*c + 10*d + 20*e == 50
# gde su promenljive a, b, c, d, e broj novcica vrednosti od 1 do 20 redom
# ukoliko se koristi ovo ogranicenje
# potrebno je funkciji addConstraint 
# proslediti i listu naziva promenljivih 
# koja odgovara datom redosledu tezina za ExactSumConstraint

problem.addConstraint(
    constraint.ExactSumConstraint(50,[1,2,5,10,20]),
    ["1 din", "2 din", "5 din","10 din", "20 din"])

# II nacin je da definisemo svoju funkciju koja predstavlja ogranicenje
# mana: solver nesto sporije radi posto ugradjene funkcije imaju optimizovanu pretragu i brze dolaze do resenja
#
#def o(a, b, c, d, e):
#	if a + 2*b + 5*c + 10*d + 20*e == 50:
#		return True
#
#problem.addConstraint(o, ["1 din", "2 din", "5 din","10 din", "20 din"])
#
resenja = problem.getSolutions()

for r in resenja:
	print("---")
	print("1 din: {0:d}, 2 din: {1:d}, 5 din: {2:d}, 10 din: {3:d}, 20 din: {4:d}".format(r["1 din"],r["2 din"],r["5 din"], r["10 din"], r["20 din"]))
	# Provera da je suma bas 50
	print("Ukupno:", r["1 din"] + r["2 din"]*2 + r["5 din"]*5 + r["10 din"]*10 + r["20 din"]*20)
	print("---")
