package main

import (
	"fmt"
	"math/rand"
)

/* Kanali (chan) su referentni tip podataka koji omogucava
dvosmernu komunikaciju izmedju dve gorutine
Tip kanala definise tip vrednosti koju je moguce poslati kroz kanal
Operator strelice <- se koristi za prosledjivanje i preuzimanje
vrednosti u, odnosno iz kanala
*/
func suma(niz []int, c chan int) {
	rezultat := 0
	for _, broj := range niz {
		rezultat += broj
	}
	// rezultat saljemo u kanal
	c <- rezultat
}

func main() {
	r := rand.New(rand.NewSource(100))
	var niz [100]int
	var broj int
	for i := 0; i < 100; i++ {
		broj = r.Intn(101)
		niz[i] = broj
	}
	// pravljenje kanala, bafer je podrazumevano velicine 1
	// u ovakvom kanalu moze u jednom trenutku
	// biti samo jedna vrednost
	c := make(chan int)

	/* Gorutine predstavljaju niti nize kategorije
	Kada se program pokrene, jedina gorutina koja postoji
	je glavna gorutina koja poziva funkciju main
	Nove gorutine, kreiraju se upotrebom kljucne reci go i navodjenjem
	funkcije koja ce se izvrsavati u novoj gorutini konkurentno */
	go suma(niz[:len(niz)/2], c) // isecak se pravi pomocu [:] operatora
	go suma(niz[len(niz)/2:], c)
	// uzimamo vrednosti iz kanala
	// glavna gorutina je blokirana dok obe gorutine ne posalju svoje vrednosti
	rez1, rez2 := <-c, <-c
	fmt.Println(rez1 + rez2)
}
