package main

import (
	"fmt"
)

// definisemo funkcije za zasebne operacije iz izraza
// svaka gorutina ubacuje rezultat u kanal
// kojim se postize sinhronizacija
func zbir(x, y int, c chan int) {
	c <- x + y
}
func proizvod(x, y int, c chan int) {
	c <- x * y
}

func main() {
	// pravimo kanal sa baferom velicine 2
	// da bi obe gorutine za zbir mogle da upisu vrednost
	// bez cekanja
	c := make(chan int, 2)
	// izraz koji treba izracunati (2+36)*(15+100)
	go zbir(2, 36, c)
	go zbir(15, 100, c)
	// uzimamo vrednosti iz kanala
	// glavna se blokira dok obe gorutine ne zavrse
	suma1, suma2 := <-c, <-c
	go proizvod(suma1, suma2, c)
	// glavna se blokira dok proizvod ne ubaci rezultat u kanal
	fmt.Printf("Vrednost izraza je %d\n", <-c)
}
