// program prevodite sa: g++ 2.cpp Segment.cpp SegmentKvadrata.cpp

#include <iostream>

/* da nismo definisali prostore imena za svaku od napravljenih biblioteka, dolazi do greske jer u obe biblioteke postoji funkcija ispis() pa njena upotreba ne bi bila moguca */
#include "Segment.h"
#include "SegmentKvadrata.h"

/*
Takodje, ukljucivanje oba prostora imena sa:

using namespace Segment;
using namespace SegmentKvadrata;
 
u ovom slucaju dovodi do greske jer se sada sve funkcije iz ovih prostora gledaju kao globalne u nasem programu pa ce postojati konflikt izmedju funkcija ispis() iz ovih prostora

Zbog svega navedenog se preporucuje da se nove klase, funkcije definisu u korisnickim prostorima imena i da se van tih prostora koriste navodjenjem prefiksa prostora kome pripadaju.  

*/

/* 
ipak, neke objekte i klase iz prostora std cesto koristimo, pa bi njihova upotreba bez navodjena prefiksa bila pogodnija, u tom slucaju koristimo using - deklaraciju kojom se ukljucuje samo navedeni objekat ili klasa, a ne ceo prostor imena ( ipak, i u ovom slucaju se mora voditi racuna da li moze doci do konflikta, u nasem primeru, ako bismo pokusali nesto ovako:

using Segment::ispis;
using SegmentKvadrata::ispis;

dovodi do greske, ali na primer ako bismo naveli samo

using Segment::ispis;

sa ispis(n) bi automatski pozivali funkciju iz prostora Segment i nema konflikta, jer se funkciji ispis() iz prostora SegmentKvadrata pristupa navodjenjem prefiksa )
  
*/
using std::cout; // sada cout i std::cout imaju isto znacenje

int main(){
	int n;
	cout << "Unesite pozitivan broj: " << std::endl;
	std::cin >> n;
	/* poziv funkcije paran() bez odredjenog prefiksa dovodi do greske jer funkcija nije globalno definisana vec u okviru prostora Segment */ 
	if(Segment::paran(n)){
		cout << "Parni brojevi iz segmenta [0, " << n << "]: " << std::endl;
		// pozivamo funkciju ispis iz prostora Segment
		Segment::ispis(n);
	}
	else{
		cout << "Neparni brojevi iz segmenta [0, " << n << "]: " << std::endl;
		// pozivamo funkciju ispis iz prostora Segment		
		Segment::ispis(n);	
	}
	cout << "Kvadrati brojeva iz segmenta [0, " << n << "]: "<< std::endl;
	// pozivamo funkciju ispis iz prostora segment_kvadrata		
	SegmentKvadrata::ispis(n);

}
