// program prevodite sa: g++ 3.cpp Trougao.cpp

#include <iostream>
#include "Trougao.h"

/* klasa Trougao je definisana u okviru prostora imena geometrija pa joj pristupamo koriscenjem prefiksa geometrija:: */
int main(){
	// Kreiramo objekat t (poziva se konstruktor sa tri realna broja) 
	geometrija::Trougao t(2, 3, 4);

	std::cout << "Obim trougla " << t << " je: " << t.obim() << std::endl;
	std::cout << "Povrsina trougla " << t << "je: " << t.povrsina() << std::endl;

	t.postavi(3,4,5);
	std::cout << "Obim trougla " << t << " je: " << t.obim() << std::endl;
	std::cout << "Povrsina trougla " << t << "je: " << t.povrsina() << std::endl;
  
	const geometrija::Trougao s(1, 2.5, 3);
    // s.postavi(5, 6, 7); // ovo ne radi, jer je s konstantan, a postavi() nije konstantna metoda

	if(t.imaVeciObimOd(s)){
		std::cout << "Trougao " << t << " ima veci obim od trougla " << s << std::endl;
	}
	else{
		std::cout << "Trougao " << t << " ima manji obim od trougla " << s << std::endl;
	}
	// Dozvoljeno je objekat inicijalizovati drugim objektom istog tipa,
	// kao i u C-u. Semantika ove inicijalizacije je podrazumevano "clan po clan"
	geometrija::Trougao p = t;
  
	// Dodela jednog objekta drugom objektu istog tipa je takodje dozvoljena.
	// Vrsi se uobicajena dodela kopiranjem "clan po clan", kao i u C-u.
	p = t;

	// Ovako se objekti mogu kreirati dinamicki. Ukoliko zelimo da pozovemo
	// podrazumevani konstruktor, pisali bi pt = new Trougao; (ovde ne bi 
	// radilo, zato sto klasa Trougao nema podrazumevani konstruktor, ali je
	// inace takva sintaksa). 
	geometrija::Trougao * pt = new geometrija::Trougao(3,4,5);

	// *pt predstavlja dinamicki kreirani objekat. pt->obim() vratice obim ovog
	// trougla.
	std::cout << p.imaVeciObimOd(*pt) << std::endl;
	std::cout << pt->obim() << std::endl;

	delete pt;
	
}
