from PyQt5 import QtWidgets, QtGui
from random import randint

class Gui(QtWidgets.QWidget):
    def __init__(self):
        super().__init__()
        self.initGui()

    def initGui(self):
        self.setGeometry(200,200,420,200)
        self.setWindowTitle('kvadrati')
        self.show()

    def paintEvent(self, e):
        """
        metod paintEvent je nasledjen iz klase QWidget
        i izvrsava se nakon poziva show metoda

        crtanje na prozoru aplikacije se realizuje
        koriscenjem objekta klase QPainter iz modula QtGui
        """
        qp = QtGui.QPainter()
        # ceo kod za crtanje se navodi izmedju begin i end metoda
        # begin metodu se prosledjuje referenca za objekat na kom se crta
        # u nasem slucaju je to upravo prozor aplikacije
        qp.begin(self)
        # izvojen metod za crtanje kvadrata
        self.kvadrati(qp)
        qp.end()

    def kvadrati(self, qp):
        # za svaki kvadrat generisemo RGB format za boju
        for k in range(3):
            r = randint(0,255)
            g = randint(0,255)
            b = randint(0,255)
            # QColor konstruktoru se prosledjuju
            # kolicina crvene, zelene i plave redom
            color = QtGui.QColor(r,g,b)
            # postavljamo boju za pozadinu kvadrata
            qp.setBrush(color) 
            # ukoliko ne zelimo da se boji pozadina
            # vec samo da se isrta okvir:
            # qp.setPen(color)
            
            # prosledjuju se koordinate gornjeg levog ugla
            # i dimenzije kvadrata
            qp.drawRect(50+k*110,50,100,100)


app = QtWidgets.QApplication([])
window = Gui()
app.exec_()