from PyQt5 import QtWidgets, QtGui
from random import randint

class Gui(QtWidgets.QWidget):
    def __init__(self):
        super().__init__()
        self.initGui()

    def initGui(self):
        self.setGeometry(200,200,420,200)
        self.setWindowTitle('kvadrati')
        # podatak kojim se kontrolise crtanje kvadrata
        # na pocetku kvadrati ne treba da se crtaju
        self.crtaj = False
        self.dugme = QtWidgets.QPushButton('CRTAJ',self)
        # svaku komponentu mozemo pomeriti u odnosu na roditeljsku
        self.dugme.move(160,20)
        self.dugme.resize(80,20)
        # klikom na dugme treba da se iscrtaju kvadrati
        self.dugme.clicked.connect(self.crtanje)
        self.show()

    def crtanje(self):
        self.crtaj = True
        # potrebno je azurirati aplikaciju
        # update-om se ponovo izvrsava paintEvent metod
        # pri cemu ce se videti novo stanje promenjive crtaj
        self.update()

    def paintEvent(self, e):
        """
        metod paintEvent je nasledjen iz klase QWidget
        i izvrsava se nakon poziva show metoda

        ukoliko nam to ne odgovara, mozemo uvesti 
        promenljivu koja kontrolise crtanje 
        """
        if self.crtaj:
            qp = QtGui.QPainter()
            qp.begin(self)
            self.kvadrati(qp)
            qp.end()

    def kvadrati(self, qp):
        # za svaki kvadrat generisemo RGB format za boju
        for k in range(3):
            r = randint(0,255)
            g = randint(0,255)
            b = randint(0,255)
            # QColor konstruktoru se prosledjuju
            # kolicina crvene, zelene i plave redom
            color = QtGui.QColor(r,g,b)
            # postavljamo boju za pozadinu kvadrata
            qp.setBrush(color) 
            # ukoliko ne zelimo da se boji pozadina
            # vec samo da se isrta okvir:
            # qp.setPen(color)
            
            # prosledjuju se koordinate gornjeg levog ugla
            # i dimenzije kvadrata
            qp.drawRect(50+k*110,50,100,100)


app = QtWidgets.QApplication([])
window = Gui()
app.exec_()