package main

import (
	"fmt"
	"io" // sadrzi EOF
	"os" // sadrzi funkcije za rad sa datotekama
)

func suma(niz []int) int {
	rezultat := 0
	// for se moze koristiti sa sekvencom vrednosti
	// for indeks, vrednost := range sekvenca { blok }
	// ukoliko nam indeks nije potreban moze se koristiti anonimna promenljiva _
	for _, broj := range niz {
		rezultat += broj
	}
	return rezultat
}

func main() {
	// otvaranje datoteke
	// poruku o greski dobijamo preko druge povratne vrednosti
	file, err := os.Open("brojevi.txt")
	// ukoliko je uspesno otvorena datoteka err je nil
	if err != nil {
		fmt.Println("Greska prilikom otvaranja datoteke")
		// prekidamo program
		os.Exit(1)
	}
	var broj int
	var niz []int // prazan niz
	for {
		// ucitavamo broj iz datoteke i novi red na kraju linije
		_, err := fmt.Fscanf(file, "%d\n", &broj)
		if err != nil {
			// mozda smo dosli do kraja fajla
			// samo prekidamo dalje citanje
			if err == io.EOF {
				break
			}
			fmt.Println("Lose formatirana datoteka\n")
			os.Exit(1)
		}
		// ako je ucitan broj, dodajemo ga u niz
		niz = append(niz, broj)
	}
	fmt.Println(niz)
	fmt.Println(suma(niz))
}
