# Sortiranje
#
# sorted(kolekcija [, kljuc [, obrni]]) - vraca sortiranu kolekciju
#
# kolekcija - kolekcija koju zelimo da sortiramo
# kljuc - funkcija koja vraca kljuc po kome se poredi
# obrni - True/False (opadajuce/rastuce)
#
# Ukoliko zelimo da sortiramo po odredjenoj funkciji, mozemo iskoristiti 
# funkciju iz `functools` modula `cmp_to_key()` koja ce prosledjenu
# funkciju "transformisati" u argument kljuc po kojem se poredi.
# Funkcija koja se prosledjuje funkciji cmp_to_key() ima potpis:
# foo(x, y) -> integer
# i vraca negativnu vrednost ako je x < y, 0 za x == y i pozitivnu vrednost za x > y
#
# primer:
# 
# def foo(x, y):
#     return x + y
# sorted(kolekcija, key=functools.cmp_to_key(foo))
#
# napomena: foo se prosledjuje bez zagrada jer se prosledjuje objekat koji
# predstavlja funkcija a ne povratna vrednost funkcije (zagrade znace da se 
# funkcija evaluira za date argumente)

import json
import math

# l = ["A", "C", "D", "5", "1", "3"]
# print(l)
# print("sortirana lista: ", sorted(l))  # definisan operator < nad niskama

# U sledecem primeru je neophodno da definisemo svoje funkcije za vracanje kljuca po kom se poredi jer je kolekcija lista recnika i nad njima nije definisan operator '<'
with open("tacke.json","r") as f:
    tacke = json.load(f)

# Za definisanje kljuca poredjenja tacaka iskoristicemo unarnu funkciju kljuc
def kljuc(x):
    return math.sqrt(x['koordinate'][0]**2 + x['koordinate'][1]**2)

sortirane_tacke = sorted(tacke, key=kljuc)  # Optimizacija: bez .sqrt; reverse=True za obratan redosled
print(sortirane_tacke)
print("Tacke pre sortiranja:")
for item in tacke:
        print(item["teme"],)
print("\nTacke nakon sortiranja: ")
for item in sortirane_tacke:
        print(item["teme"],)
print()

# drugi nacin koriscenjem nase funkcije za poredjenje tacaka:
#
# import functools
#
# def poredi(tacka1, tacka2):
#    dtacka1 = tacka1['koordinate'][0]**2 + tacka1['koordinate'][1]**2
#    dtacka2 = tacka2['koordinate'][0]**2 + tacka2['koordinate'][1]**2
#    return dtacka1 - dtacka2
#
# sortirane_tacke = sorted(tacke, key=functools.cmp_to_key(poredi))  

# ako zelimo da poredimo po dodatnom kriterijumu
# ako su iste udaljenosti, poredimo leksikografski po nazivu temena

def poredi(tacka1, tacka2):
    dtacka1 = tacka1['koordinate'][0]**2 + tacka1['koordinate'][1]**2
    dtacka2 = tacka2['koordinate'][0]**2 + tacka2['koordinate'][1]**2
    razlika = dtacka1 - dtacka2
    if razlika == 0:
        if tacka1['teme'] < tacka2['teme']:
            return -1
        elif tacka1['teme'] > tacka2['teme']:
            return 1
        else: 
            return 0
    else:
        return razlika

import functools  
# cmp_to_key

print(sorted(tacke, key = functools.cmp_to_key(poredi)))


