// prevodjenje programa: g++ 4.cpp Trougao.cpp 
#include <iostream>
#include "Trougao.h"

/* Sabloni funkcija omogucavaju da se definicija funkcije parametrizuje
 nekim tipom, ili tipovima. Na ovaj nacin se jednom definicijom zapravo
 definise citava familija funkcija, za razlicite vrednosti tipskih 
 parametara. Sabloni funkcija imaju sledecu sintaksu:
 
 template <lista_tipskih_parametara> definicija_funkcije
 
 Kljucnom recju template pocinje definicija sablona. Nakon toga u 
 zagradama < > sledi neprazna lista tipskih parametara razdvojenih
 zarezima, pri cemu svaki tipski parametar ima oblik:
 
 typename T
 
 ili 
 
 class T
 
 gde je typename odnosno class kljucna rec (potpuno je svejedno koju cete
 koristiti, ista je semantika u ovom kontekstu), a T je proizvoljan 
 identifikator (naravno, ako ima vise parametara, svi moraju imati
 razlicite identifikatore). Definicija funkcije moze biti proizvoljna,
 kao i kod obicnih funkcija, s tim sto se navedeni tipski parametri 
 sablona mogu koristiti bilo gde gde se ocekuje tip (npr, u povratnom
 tipu, tipovima parametara funkcije, tipovima lokalnih promenljivih).
 
 Kada se ovako definisana funkcija (zapravo sablon funkcija) pozove, 
 tada se na osnovu stvarnih tipova argumenata poziva vrsi tzv. 
 "dedukcija tipova parametara sablona", sto znaci da se parametrima sablona
 dodeljuju odgovarajuci tipovi, ako je to moguce. Nakon uspesne dedukcije,
 dolazi do "instanciranja sablona", tj. do kreiranja konkretne funkcije koja
 nastaje iz sablona tako sto se svaka pojava nekog tipskog parametra 
 zamenjuje odgovarajucim konkretnim tipom. */

/* sablon za odredjivanje maksimuma: 

* prva verzija *

template <typename T>
T maksimum(const T x, const T y){
	return x > y ? x : y;
} 

iako ovo ne pravi bitnu razliku kada se instancira sablon za primitivan tip T, 
ako bi T bio klasni tip, tada bi se kopirali citavi objekti u lokalne promenljive
za funkciju sto je svakako neefikasno, pa se zbog toga preporucuje da sablon kao
argumente ima reference:

* efikasnija verzija *

template <typename T>
T maksimum(const T& x, const T& y){
	return x > y ? x : y;
}

*/


/* povratna vrednost je objekat tipa T, ako bi vracali referencu, kompajler prijavljuje upozorenje
 - iako referenca na lokalnu promenljivu moze da prodje sintaksno (dobija se upozorenje, a ne greska), 
 ovo treba izbegavati jer je ponasanje programa nedefinisano standardom
 kada je povratna vrednost objekat koji se lokalno kreirao, program vodi racuna da ovakve objekte ne unistava odmah
 nakon zavrsetka funkcije koja ga je kreirala */
template <typename T>
T n_tostruki(const T& x, int n){
	int i=1;
	T zbir = x;
	while(i<n){
		zbir = zbir + x;
		i++;
	}		
  return zbir;
}

template <typename T>
T manji(const T& x, const T& y){
	if(x<y)
		return x;		
	else
		return y;
}

template <typename T>
T zbir(const T& x, const T& y){
	return x+y;
}

int main(){
	geometrija::Trougao t(2, 3, 4);
	geometrija::Trougao s(5, 6, 7);
	float x = 10.3, y = 101.1;
	int a = 5, b = 10, n = 3;
	 
	std::cout<< "Manji od trouglova " << t << " i " << s << " je: " << manji<geometrija::Trougao>(t,s)<< std::endl; 
	std::cout<< "Manji od brojeva " << x << " i " << y << " je: " << manji<float>(x,y)<< std::endl;
	std::cout<< "Manji od brojeva " << a << " i " << b << " je: " << manji<int>(a,b)<< std::endl;

	/* Ovo ne radi: dedukcija tipova nece uspeti, jer je na prvom argument int, a na drugom float. 
	 Prilikom dedukcije tipova prevodilac ne dozvoljava konverzije, tj. ne moze se zakljucti da je T = int na osnovu prvog argumenta,
	 pa da se onda drugi konveruje iz float u int, ili obrnuto. Prevodilac prijavljuje gresku za:
	 std::cout << "Manji je: "<< manji(a, x) << std::endl;
	 
	 Da bismo razresili gornji problem, ekplicitno navodimo koji tip hocemo da koristimo za T. 
	 Nakon sto se instancira sablon za T = float, poziva se taj primerak, pri cemu se prvi argument (koji je tipa int)
	 konvertuje u double (konverzije su zabranjene samo u toku dedukcije tipova) */
	std::cout << "Manji je: "<< manji<float>(a, x) << std::endl;

	std::cout<< "Zbir trouglova " << t << " i " << s << " je: " << zbir<geometrija::Trougao>(t,s)<< std::endl;   	
	
	std::cout<< n << " * " << a << " = " << n_tostruki<int>(a,n)<<std::endl;
	std::cout<< n << " * " << x << " = " << n_tostruki<float>(x,n)<<std::endl;

}
