import numpy as np
import math 
from matplotlib import pyplot as plt

# funkcija racuna rastojanje izmedju dve tacke
def rastojanje(x1, y1, x2, y2):
    return math.sqrt((x2 - x1) ** 2 + (y2 - y1) ** 2)

# funkcija kojom se odredjuje boja na osnovu udaljenosti
def boja(d):
    if (d < 0.5):
        return 'r'
    elif (d < 1.0):
        return 'y'
    elif (d < 1.5):
        return 'g'
    else:
        return 'b'

# broj tacaka
N = 20000

# centralna tacka od koje se racuna rastojanje 
cx = 2
cy = 2

# funkcija rand iz numpy.random modula 
# vraca niz nasumicnih brojeva iz intervala [0,1)
# argument je dimenzija niza koji se kreira 
# interval [0,1) preslikavamo u interval [0,4)
x = np.random.rand(N) * 4
y = np.random.rand(N) * 4

# lista boja tacaka 
# zip funkcija od dve liste pravi zip objekat 
# koji predstavlja posebnu kolekciju parova
# tako da je i-ti par napravljen od i-tih elemenata datih kolekcija
c = [boja(rastojanje(cx, cy, xp, yp)) for xp,yp in zip(x, y)]

plt.scatter(x, y, c=c, s=1)
plt.show()
