// b)
package main

import (
	"fmt"
	"runtime"
	"sync"
)

var wg sync.WaitGroup

// deljeni podaci
var vektor []int
var n int
var skalar int

/* I nacin: gorutine rade sa odredjenim iseckom niza

definisemo funkciju za mnozenje
argumenti: leva i desna granica isecka niza kojoj pristupa gorutina
i redni broj gorutine preko kog pratimo kako se obavlja mnozenje */
func mnozenjeIsecak(l, r, rb int) {
	for i := l; i < r; i++ {
		fmt.Printf("Gorutina %d mnozi el. na poziciji %d\n", rb, i)
		vektor[i] *= skalar
	}
	// svaka gorutina na kraju svog izvrsavanja
	// obavestava glavnu gorutinu da je zavrsila
	wg.Done()
}

/* II nacin: gorutine rade sa odredjenim pozicijama niza, redom delimo elemente po gorutinama

definisemo funkciju za mnozenje
argument: redni broj gorutine i ukupan broj gorutina
pozicije u nizu koje obradjuje gorutina se racunaju na osnovu ostatka pri deljenju sa brojGR
0. gorutina -> uzima elemente sa pozicija koje su deljive sa brojGR
1. gorutina -> uzima elemente sa pozicija koje daju ostatak 1 pri deljenju sa brojGR */

func mnozenjeOstatak(rb, brojGR int) {
	for i := rb; i < n; i += brojGR {
		fmt.Printf("Gorutina %d mnozi el. na poziciji %d\n", rb, i)
		vektor[i] *= skalar
	}
	// svaka gorutina na kraju svog izvrsavanja
	// obavestava glavnu gorutinu da je zavrsila
	wg.Done()
}

func main() {
	// ucitavamo podatke za obradu
	fmt.Scanf("%d", &n)
	vektor = make([]int, n)
	for i := 0; i < n; i++ {
		fmt.Scanf("%d", &vektor[i])
	}
	fmt.Println(vektor)
	fmt.Scanf("%d", &skalar)

	// broj gorutina definisemo u skladu sa mogucnostima sistema
	brojGR := runtime.NumCPU()
	/*
		delimo posao po gorutinama unapred: svaka nit radi na svom isecku niza
		zbog ovakve organizacije nije potrebna sinhronizacija
		jer ne postoji kriticna sekcija, nit samo treba da obavesti preko
		WaitGroup strukture glavnu gorutinu da je zavrsila svoj deo posla
	*/
	wg.Add(brojGR)
	// Za I nacin preko funkcije mnozenjeIsecak
	// odredjujemo isecke po gorutinama
	kolicnik := n / brojGR
	ostatak := n % brojGR
	var duzinaIsecka int
	/* slucaj kad duzina niza nije deljiva brojem gorutina
	na primer, n = 10 i brojGR = 4
	tada cemo dati po 3 elementa 1. i 2. gorutini
	i po 2 elementa 3. i 4. gorutini na obradu
	*/
	if ostatak > 0 {
		duzinaIsecka = kolicnik + 1
		ostatak--
	} else {
		duzinaIsecka = kolicnik
	}
	for l, r, rg := 0, duzinaIsecka, 0; rg < brojGR; rg++ {
		// saljemo levu i desnu granicu niza
		go mnozenjeIsecak(l, r, rg)
		// azuriramo podatke za sledecu gorutinu
		l = r
		// rasporedili smo viskove
		// ostale gorutine obradjuju po kolicnik elemenata
		if ostatak <= 0 {
			duzinaIsecka = kolicnik
		} else {
			ostatak--
		}
		r += duzinaIsecka
	}
	/* Za II nacin preko funkcije mnozenjeOstatak
	for rb:=0;rb<brojGR;rb++{
		go mnozenjeOstatak(rb, brojGR)
	}
	*/
	// glavna gorutina ceka ostale da zavrse obradu niza
	wg.Wait()
	// ispis rezultata
	fmt.Println(vektor)
}
