/* Umesto C-ovih FILE tokova, u C++ postoje klasni tipovi istream, ostream, koji predstavljaju ulaz i izlaz (ifstream i ofstream su ekvivalentne klase za rad sa fajlovima). Ukljucivanjem zaglavlja iostream automatski se ukljucuju definicije svih ovih tipova. Takodje, ovo zaglavlje definise i tri konkretna objekta: cin, cout, cerr (koji su ekvivalenti C-ovim stdin, stdout i stderr pokazivacima). Pomocu ovih objekata koristimo standardni ulaz i izlaz. */

#include <iostream>

/* Programski jezik C++ uvodi pojam "prostora imena" (eng. namespace). Prostori imena imaju ulogu da grupisu tipove, promenljive (objekte) i funkcije koji su na neki nacin logicki povezani i cine celinu. Identifikatorima koji su definisani u okviru prostora imena pristupa se na sledeci nacin:

	<ime_prostora>::<identifikator>

Samim tim, svaki objekat, klasa ili funkcija iz standardne biblioteke mora imati prefiks std:: prilikom koriscenja. Npr. umesto cout morate pisati std::cout. Da ne bi stalno navodili ovaj prefiks ispred imena objekata, narocito ako smo sigurni da identifikatori iz tog prostora nece doci u konflikt sa identifikatorima iz drugih prostora, postoji mogucnost da se "ukljuci" ceo prostor imena, direktivom 'using namespace <ime_prostora>;'. Nakon ove direktive, identifikatori iz ukljucenog prostora se mogu koristiti bez prefiksa, kao da su definisani na globalnom nivou. */

using namespace std;

void
swapLosaVarijanta (int a, int b)
{
  int temp = a;
  a = b;
  b = temp;
}

/* Za svaki tip T u C++-u je moguce definisati tip T & koji se zove "referenca na T". Analogno pokazivacima, koji pokazuju na neki objekat tipa T, za reference kazemo da "referisu" na objekat tipa T. Na primer:

	int x;
	int & r = x;

Promenljiva r je tipa "int &" , (cita se "referenca na int") koja je inicijalizovana da referise na int varijablu x. Semanticki, referenca je slicna pokazivacima, tj. omogucava da se preko nje pristupi drugom objektu u memoriji. Medjutim, postoje neke kljucne razlike:

1) Referenca se inicijalizuje samim objektom, a ne adresom tog objekta.
2) Referenca se mora inicijalizovati (pokazivacka promenljiva se moze kreirati neinicijalizovana, ili se inicijalizovati nulom, tj. da ne pokazuje ni na sta inicijalno).
3) Referenca do kraja svog zivota referise na taj isti objekat kojim je inicijalizovana (pokazivac se moze "preusmeriti" da pokazuje na nesto drugo u kasnijem toku programa).
4) Referenca se uvek odnosi na objekat na koji referise, tj. kada god napisemo r, to je isto (i po tipu, i po vrednosti, i po adresi), kao da ste napisali x, gde je x objekat na koji r referise. Dakle, jezik ne pruza sintaksnu mogucnost da se pristupi samoj referencnoj promenljivoj. Izraz:

	r++;
	uvecace promenljivu x za jedan.

Pravi smisao referenci se ogleda u referencnim parametrima funkcija. Time se omogucava prenosenje podataka po adresi, mnogo lakse i sintaksno udobnije za koriscenje od pokazivaca. Referenca se moze inicijalizovati samo "levim vrednostima", tj. izrazima koji mogu da stoje na levoj strani operatora dodele:

	int & r = x; // ok
	int & r = a[i]; // ok, za niz int-ova
	int & r = *p; // ok, gde je p pokazivac na int.
	int & r = x + 1; // ne valja!! x + 1 nije leva vrednost
	float f;
	int & r = f; // ne valja, mora biti leva vrednost tipa int
	int & r = x++; // ne valja, operator ++ ne vraca levu vrednost */


void
swap (int &a, int &b)
{
  int temp = a;
  a = b;
  b = temp;
}

int
main ()
{
  int a, b;
/* Ulazni i izlazni tokovi (istream i ostream) u kombinaciji sa operatorima << i >> su prilicno "pametni" -- za razliku od C-ovih scanf() i printf() funkcija, ovde vam nisu potrebni specifikatori konverzije (%d, %f, i sl.), da bi on znao o kom se tipu radi -- sve se automatski prepoznaje. Operator << preusmerava ono sto je sa desne strane na izlazni tok, a operator >> prebacuje informacije sa ulaznog toka u promenljive iz programa. */
  cout << "Unesite dva cela broja:" << endl;
  cin >> a >> b;
  cout << "a=" << a;
  cout << " b=" << b << endl;
  swapLosaVarijanta (a, b);
  cout << "a=" << a << " b=" << b << endl;
/* Prilikom poziva ne treba navoditi operator &, jer parametri funkcije nisu pokazivaci, vec reference. Referencni parametri funkcije se inicijalizuju
da referisu na promenljive a i b funkcije main(). */
  swap (a, b);
  cout << "a=" << a << " b=" << b << endl;

}
