#include "Trougao.h"

namespace geometrija{

/* prazan konstruktor, ako njega ne definisemo, naredba 

	Trougao t;

prijavljuje gresku, jer se tu poziva podrazumevani konstruktor */

Trougao::Trougao(){ 

} 

/* Za trougao treba da bude ispunjeno da je svaka stranica kraca od zbira druge dve i da je svaka stranica veca od razlike druge dve stranice tog trougla.
Funkcija je deklarisana u klasi kao static jer prakticno nije vezana za objekat klase Trougao i moze biti pozvana i kad ne postoji objekat nase klase. Koristimo je u konstruktoru i kad korisnik pokusava da promeni vrednosti podacima. U static funkcijama ne mozemo koristiti this pokazivac, prilikom definicije ne stavljamo static */
bool Trougao::provera(double a, double b, double c){
	if(a < b + c && b < a + c && c < a + b && a > fabs(b - c) && b > fabs(a - c) && c > fabs(a - b))
		return true;
	else
		return false;
}

void Trougao::postavi(double a, double b, double c){
	/* ne dozvoljavamo promenu ukoliko provera ne prodje */
	if(Trougao::provera(a,b,c)){
			_a = a;
			_b = b;
			_c = c;
	}
	else{
		/* ukoliko neki od uslova nije ispunjen, postavljaju se podrazumevane vrednosti 2, 3, 4 */
		_a = 2.0;
    	_b = 3.0;
    	_c = 4.0;
	} 	
}

Trougao::Trougao(double a, double b, double c){ 
	postavi(a,b,c);
}

double Trougao::vratiA() const{
	return _a;
}
  
double Trougao::vratiB() const{
	return _b;
}

double Trougao::vratiC() const{
	return _c;
}

/* Primer operatora koji se ne moze definisati unutar klase Trougao, zato
 s to mu je levi operand objekat druge klase (*klase ostream) koja je
 definisana u biblioteci i mi u nju ne mozemo dodavati nove operatore.
 Zbog toga se definise na spoljasnjem nivou, sa dva parametra koji 
 odgovaraju redom levom i desnom operandu. */
std::ostream& operator << (std::ostream& ostr, const Trougao& t){
	ostr << "(" << t.vratiA() << ", " << t.vratiB() << ", " << t.vratiC() << ")";
	/* Operator << ciji je levi operand objekat klase ostream uvek vraca referencu na sam objekat klase ostream za koju je i pozvan. Na taj nacin se omogucava nadovezivanje operatora << prilikom ispisa, s obzirom na levu asocijativnost ovog operatora. Referenca na ostream nema kvalifikator const, zato sto se prilikom ispisa interno stanje ostream objekta menja (sto bi bilo spreceno kada bismo ga kvalifikovali kao const). */
	return ostr;
}

std::istream& operator >> (std::istream& istr, Trougao& t){
	double a, b, c;
	istr >> a >> b >> c;
	t.postavi(a,b,c);
	return istr;
}


}
