#include <iostream>
#include <vector>
#include <list>
#include "Fun.h"

using std::cout;
using std::cin;
using std::endl;


/* sablon za ispis proizvoljne kolekcije */
template <typename Kol>
void ispis(const Kol &k){
	for(typename Kol::const_iterator it=k.begin(); it!=k.end(); it++){
		cout<< *it << " ";
	}
	std::cout << std::endl;
}

/* sablon za ucitavanje proizvoljne kolekcije, kolekcija tipa Kol kao elemente ima objekte tipa T */
template <typename Kol, typename T>
void ucitaj(Kol &k, int n){
	T x;
	for(int i=0; i<n; i++){
		cin>>x;
		k.push_back(x);
	}
}

/* sablon kojim transformisemo datu kolekciju, ostavljajuci samo one elemente kolekcije 
koji zadovoljavaju uslov predstavljen funkcionalom f */
template <typename Kol, typename Funkcional>
void transformisi(Kol &k, const Funkcional &f){
	for(typename Kol::iterator it = k.begin(); it!=k.end();){
		/* nad funkcionalom koji prosledjujemo
		 kao argument, je moguce simulirati primenu
		 funkcije (unarnog uslova), kao da je to prava funkcija,
		 a ne objekat */
		if(!f(*it))
			it = k.erase(it);
		else
			it++;
	}
}

int main(){
	unsigned n;
	cout<<"Unesite broj elemenata niza:"<<endl;
	cin >> n;
	std::vector<int> v1;
	cout<<"Unesite niz celih brojeva:"<<endl;
	ucitaj< std::vector<int>, int>(v1,n);
	cout<<"Uneli ste niz:"<<endl;
	ispis(v1);
	int osnovad;
	cout<<"Unesite ceo broj (za proveru deljivosti):"<<endl;
	cin >> osnovad;
	funkcional::Div<int> funkDiv(osnovad);
	cout<<"Niz nakon izmene (svi deljivi sa " << osnovad << "):"<<endl;
	transformisi(v1, funkDiv);
	ispis(v1);

	cout<<"Unesite broj elemenata liste:"<<endl;
	cin >> n;
	std::list<double> l1;
	cout<<"Unesite listu realnih brojeva:"<<endl;
	ucitaj< std::list<double>, double>(l1,n);
	cout<<"Uneli ste listu:"<<endl;
	ispis(l1);
	double osnovap;
	cout<<"Unesite realni broj (za poredjenje):"<<endl;
	cin >> osnovap;
	funkcional::Gre<double> funkGre(osnovap);
	cout<<"Lista nakon izmene (svi veci od " << osnovap << "):" <<endl;
	transformisi(l1, funkGre);
	ispis(l1);
}
