# modul QtWidgets sadrzi klase za razlicite kontrolne elemente
from PyQt5 import QtWidgets

"""
Pravimo klasu koja nasledjuje klasu QWidget koja 
prestavlja osnovni kontrolni element - prozor aplikacije

Definicija klase:

class ImeKlase(KlasaKojaSeNasledjuje):
    definicija metoda klase

Medju metodima izdvaja se __init__ metod
koji sluzi za inicijalizaciju instance klase.
U okviru tog metoda definisemo polja podatke klase.

"""
class Gui(QtWidgets.QWidget):
    def __init__(self):
        # pozivamo metod za inicijalizaciju 
        # iz roditeljske klase
        super().__init__()
        # ostale postavke su izvojene u metodu initUI
        self.initUI()

    # self je referenca na instancu klase
    def initUI(self):
        # prva dva argumenta su koordinate gornjeg levog ugla prozora
        # poslednja dva argumenta su dimenzije prozora
        self.setGeometry(250,250,300,300)
        self.setWindowTitle('Program za konverziju')
        
        # koristimo tabelarnu organizaciju  
        grid = QtWidgets.QGridLayout()
        grid.setSpacing(20)
        self.setLayout(grid)

        # komponenta za unos jednolinijskog teksta
        self.text = QtWidgets.QLineEdit(self)
        # dodajemo u tabelu
        # pozicija komponente je 0, 0 -> prva vrsta i kolona
        # komponenta se prostire u jednoj vrsti i dve kolone -> 1, 2
        grid.addWidget(self.text, 0, 0, 1, 2)

        # dugme
        self.evri = QtWidgets.QPushButton(self) 
        self.evri.setText('EVRI')
        # za signal vezujemo funkciju -> odgovor na signal
        # konEvri je funkcija koja ce se izvrsiti kada se klikne na dugme
        self.evri.clicked.connect(self.konEvri)

        self.din = QtWidgets.QPushButton(self) 
        self.din.setText('DINARI')
        self.din.clicked.connect(self.konDin)

        grid.addWidget(self.evri, 1, 0)
        grid.addWidget(self.din, 1, 1)

        # show pravi sve komponente u memoriji i prikazuje prozor aplikacije
        self.show()

    def konEvri(self):
            # ukoliko je neispravna vrednost 
            # konverzija u float ce izbaciti izuzetak
            try:
                broj = float(self.text.text())
                evri = broj / 118.7
                self.text.setText(str(evri))
            except:
                self.greska()

    def konDin(self):
            try:
                broj = float(self.text.text())
                dinari = broj * 118.7
                self.text.setText(str(dinari))
            except:
                self.greska()

    def greska(self):
        # pravimo prozor za prikaz poruke korisniku
        alert = QtWidgets.QMessageBox()
        alert.setWindowTitle('Poruka')
        alert.setText('Neispravna vrednost')
        alert.move(250,250)
        # da bi se pokrenuo event loop
        # tj. da bi se sacekala akcija od strane korisnika 
        # pre nego se iskljuci prozor
        alert.exec_()

# pravimo instancu koja predstavlja aplikaciju
app = QtWidgets.QApplication([])
# prozor aplikacije
window = Gui()
# pokretanje main event loop-a
# kako bi se sacekala akcija od strane korisnika
app.exec_()