from PyQt5 import QtWidgets
import json

class Gui(QtWidgets.QWidget):
    def __init__(self):
        super().__init__()
        self.initGui()
        self.show()

    def initGui(self):
        self.resize(300,150)
        # komponente se dodaju jedna pored druge
        # s leva na desno u redosledu u kom se ubacuju u hbox
        hbox = QtWidgets.QHBoxLayout()
        self.setLayout(hbox)
        self.lnalog = QtWidgets.QLabel("alas nalog", self)
        self.nalog = QtWidgets.QLineEdit(self)
        self.lprosek = QtWidgets.QLabel("prosek nepoznat", self)
        hbox.addWidget(self.lnalog)
        hbox.addWidget(self.nalog)
        hbox.addWidget(self.lprosek)
        self.dugme = QtWidgets.QPushButton("pronadji",self)
        self.dugme.clicked.connect(self.pronadjiStudenta)
        hbox.addWidget(self.dugme)

    def pronadjiStudenta(self):
        # text metod vraca unet sadrzaj 
        nalog = self.nalog.text()
        # cuvamo podatak da li smo pronasli studenta
        nasli = 0
        with open('studenti.json') as f:
            studenti = json.load(f)
            # pretraga liste recnika
            for s in studenti:
                if s['nalog'] == nalog:
                    self.lprosek.setText("prosek je {:.2f}".format(s['prosek']))
                    # registrujemo da smo pronasli studenta
                    # i prekidamo pretragu 
                    nasli = 1
                    break
        # u slucaju da nije pronadjen trazeni student
        if nasli == 0:
           self.lprosek.setText("nepoznat nalog")
                         
app = QtWidgets.QApplication([])
window = Gui()
app.exec_()