/* na pocetku programa se navodi naziv paketa
paket koji sadrzi main funkciju mora da se zove main */
package main

/* ukljucivanje dodatnih paketa
ako se ukljuci paket koji se ne koristi u programu
prijavice se greska prilikom prevodjenja */
import (
	"fmt"  // formatiran ulaz/izlaz
	"math" // matematicke funkcije i konstante
)

/* struktura - grupise vise elemenata proizvoljnog tipa
definisanje novog tipa strukture:
	type Ime struct { polja strukture } */
type Tacka struct{ X, Y int }

/* definisanje funkcije:
func ImeFunkcije (parametri) (povratne vrednosti) { telo } */
func rastojanjeTacaka(t1, t2 Tacka) float64 {
	//Go ne podrzava automatsku konverziju tipova vrednosti
	return math.Sqrt(float64((t1.X-t2.X)*(t1.X-t2.X) + (t1.Y-t2.Y)*(t1.Y-t2.Y)))
}

/* Go ne podrzava klase, ali se moze definisati funkcija za korisnicki definisan tip podataka
i takve funkcije nazivamo metodima. Metod se definise tako sto se nakon kljucne reci func
doda prijemnik, odnosno tip nad kojim se metod poziva. */

func (t Tacka) rastojanje() float64 {
	return math.Sqrt(float64(t.X*t.X + t.Y*t.Y))
}

// funkcija od koje zapocinje izvrsavanje
func main() {

	// deklaracija promenljive
	var X int
	// definicija promenljive
	X = 10

	// ili uvodjenje promenljive operatorom :=
	// zamenjuje prethodne dve naredbe
	Y := 5

	t1 := Tacka{X, Y}
	t2 := Tacka{-9, 10}

	// Println ispisuje zadate vrednosti razdvojene razmakom
	// i prelazi u novi red
	fmt.Println(t1, t2)

	// Printf se koristi sa specifikatorima tipa promenljivih kao u C-u
	fmt.Printf("Udaljenost tacaka je %f.\n", rastojanjeTacaka(t1, t2))

	r1 := t1.rastojanje()
	r2 := t2.rastojanje()
	// naredbe grananja zahtevaju oznaku bloka {}
	// cak i da je samo jedna naredba u bloku
	if r1 < r2 {
		fmt.Println("Tacka ", t1, " je bliza koordinatnom pocetku.")
	} else if r1 == r2 {
		fmt.Println("Tacke su podjednako udaljene od koordinatnog pocetka.")
	} else {
		fmt.Println("Tacka ", t2, " je bliza koordinatnom pocetku.")
	}
}
