# ukljucujemo model za rad sa csv fajlovima
import csv

with open('automobili.csv') as csv_file:
    # citamo pomocu reader objekta 
    # on cita liniju po liniju csv fajla
    # kao argument se zadaje karakter delimiter podataka
    # ukoliko nije drugacije naglaseno, podrazumeva se ','
    csv_reader = csv.reader(csv_file, delimiter=',')
    brojac_linija = 0
    for linija in csv_reader:
        # nazivi kolona su uvek u prvoj liniji
        # nju nazivamo jos i zaglavljem fajla
        if brojac_linija == 0:
            print("Nazivi kolona: ",  " ".join(linija))
            brojac_linija += 1
        else:
            print("Podaci o automobilu: ", " ".join(linija))
            brojac_linija += 1
        if brojac_linija == 5:
            break
# csv fajl se moze ucitati direktno u recnik 
# pritom, podrazumeva se da su u tom fajlu nazivi kolona u prvom redu
# i da su kolone jedinstvene - posto ce biti iskoriscenje kao kljucevi recnika
#
# umesto uvodjenja brojaca moze se koristiti funkcija enumerate
# koja za svaki iterator vraca par pozicije i samog elementa
with open('automobili.csv', mode='r') as csv_file:
    csv_reader = csv.DictReader(csv_file)
    for i, linija in enumerate(csv_reader):
        if i == 5:
            break
        else:
            print(linija)
            # ukoliko je poznat naziv kolone 
            # podatku se moze pristupiti putem kljuca
            # print(linija["Model"])