#include "Osoba.h"

namespace vrsta{ 

Osoba::Osoba(){
	m_ime="";
	m_prezime="";
	m_godinaRodjenja=0;
}

Osoba::Osoba(const std::string& ime, const std::string& prezime, int god)
	: m_ime(ime), m_prezime(prezime), m_godinaRodjenja(god)
{}

std::string Osoba::Ime() const{
	return m_ime;
}

std::string Osoba::Prezime() const{
	return m_prezime;
}

int Osoba::GodinaRodjenja() const{
	return m_godinaRodjenja;
}

void Osoba::postaviIme(const std::string& ime){
	m_ime = ime;
}

void Osoba::postaviPrezime(const std::string& prezime){
	m_prezime = prezime;
}

void Osoba::postaviGodinaRodjenja(int godina){
	m_godinaRodjenja = godina;
}

bool Osoba::operator<(const Osoba &o1) const{
	return m_godinaRodjenja<o1.GodinaRodjenja();
}

std::ostream& operator<<(std::ostream& out, const Osoba &osoba){
	out<<osoba.Ime()<<" "<<osoba.Prezime()<<" "<<osoba.GodinaRodjenja();
	return out;
}

std::istream& operator>>(std::istream& in, Osoba &osoba){
	std::string ime, prezime;
	int god;
	in>>ime>>prezime>>god;
	osoba.postaviIme(ime);
	osoba.postaviPrezime(prezime);
	osoba.postaviGodinaRodjenja(god);
	return in;
}

}
