#ifndef OSOBA_H
#define OSOBA_H
#include <iostream>
#include <string>

namespace vrsta{

class Osoba{
	public:
		Osoba();
		Osoba(const std::string&, const std::string&, int godine);
		std::string Ime() const;
		std::string Prezime() const;
		int GodinaRodjenja() const;
		void postaviIme(const std::string& ime);
		void postaviPrezime(const std::string& prezime);
		void postaviGodinaRodjenja(int godina);
		bool operator <(const Osoba &o) const;
	private:
		std::string m_ime;
		std::string m_prezime;
		int m_godinaRodjenja;
};

std::ostream& operator<<(std::ostream& out, const Osoba &osoba);
std::istream& operator>>(std::istream& in, Osoba &osoba);
}
#endif

