#include <iostream>
#include <vector>

namespace matf {

    template<typename Element>
    class stack {
        public:

            inline bool empty() const {return m_elems.empty();}
            inline size_t size() const {return m_elems.size();}

            stack<Element>& operator<< (const Element& e) {
                push(e);
                return *this;
            }

            stack<Element>& operator>> (Element& e) {
                e = top();
                pop();
                return *this;
            }

        private:
            std::vector<Element> m_elems;

            void push(const Element& e) {
                m_elems.push_back(e);
            }
            void pop() {
                if(!empty()) m_elems.pop_back();
            }
            Element top() const {
                return empty() ? Element() : m_elems.back();
            }

    };
}


int main(){
    using namespace matf;
    stack<int> s;
    s << 1 << 2 << 3;
    int v1, v2;
    s >> v1 >> v2;
    std::cout << v1 << " " << v2 << std::endl;
    s >> v1 >> v2;
    std::cout << v1 << " " << v2 << std::endl;
}