// prevodjenje programa: g++ 6.cpp Osoba.cpp

#include <iostream>
#include <optional>
#include "Osoba.h"

template<typename T>
T* napravi(size_t n){
	return new T[n];
}

template<typename T>
void ucitaj(T* niz, size_t n){
	for(size_t i = 0; i != n; ++i){
		std::cin >> niz[i];
	}
}

template<typename T>
void ispisi(const T* niz, size_t n){
	for(size_t i = 0; i != n; ++i){
		std::cout << niz[i] << ' ';
	}
	std::cout << std::endl;
}


// std::optional nam sluzi da kazemo da ili vrednost ne postoji ili je samo jedna
// kao kada bi kod pokazivaca u slucaju nevalidne vrednosti vratio nullptr
// ovde se vrati prazan optional
template<typename T>
std::optional<T> maksimum(const T* niz, size_t n){
	if(n == 0){
		// Prazan optional u slucaju greske
		return std::optional<T>();
	}
	size_t curr_max = 0;
	for(size_t i = 1; i != n; ++i){
		if(niz[curr_max] < niz[i]){
			curr_max = i;
		}
	}
	// optional sa vrednoscu u slucaju normalnog toka programa
	return std::optional<T>(niz[curr_max]);
}


template<typename T>
std::ostream& operator<<(std::ostream& out, const std::optional<T>& opt){
	// konverzijom u bool proveravamo da li optional u sebi sadrzi vrednost
	if(opt){
		// ako sadrzi, preko value je dohvatamo
		out << '{' << opt.value() << '}';
	}
	else {
		out << "{}";
	}
	return out;
}

int main(){
	int n;
	int *nizInt;
	float *nizFloat;
	vrsta::Osoba *nizOsoba;
	std::cout<<"Dimenzija niza: ";
	std::cin>>n;
	
	nizInt = napravi<int>(n);
	nizFloat = napravi<float>(n);
	nizOsoba = napravi<vrsta::Osoba>(n);
	std::cout<<"Unesite "<<n<<" celih brojeva"<< std::endl;
	ucitaj(nizInt, n);
	std::cout<<"Unesite "<<n<<" realnih brojeva"<< std::endl;
	ucitaj(nizFloat, n);
	std::cout<<"Unesite "<<n<<" osoba u obliku ime prezime godina_rodjenja"<< std::endl;
	ucitaj(nizOsoba, n);
	ispisi(nizInt, n);
	ispisi(nizFloat, n);
	ispisi(nizOsoba, n);
	
	
	std::cout<<"Maksimum u nizu celih brojeva je: "<<maksimum(nizInt,n)<< std::endl;
	std::cout<<"Maksimum u nizu realnih brojeva je: "<<maksimum(nizFloat,n)<< std::endl;
	std::cout<<"Najmladja osoba (maksimalna godina rodjenja) u nizu Osoba je: "<<maksimum(nizOsoba,n)<< std::endl;
	
	delete [] nizInt;
	delete [] nizFloat;
	delete [] nizOsoba;	
	
}
