#include <iostream>
#include <vector>
#include <list>

using std::cout;
using std::cin;
using std::endl;


/* sablon za ispis proizvoljne kolekcije */
template <typename Kol>
void ispis(const Kol &k){
	for(typename Kol::const_iterator it=k.begin(); it!=k.end(); it++){
		cout<< *it << " ";
	}
	std::cout << std::endl;
}

/* sablon za ucitavanje proizvoljne kolekcije, kolekcija tipa Kol kao elemente ima objekte tipa T */
template <typename Kol, typename T>
void ucitaj(Kol &k, int n){
	T x;
	for(int i=0; i<n; i++){
		cin>>x;
		k.push_back(x);
	}
}


/* umesto da pisemo zasebne funkcije za proveru uslova
 da li su svi elementi deljivi/nedeljivi, veci, manji od nekog 
 broja, mozemo da napisemo jednu funkciju viseg reda
 koja prosledjeni unarni uslov primenjuje
 nad svim elementima kolekcije proizvoljnog tipa 
 
 u je pokazivac na unarni uslov (funkciju) koji kao argument prima
 referencu na objekat tipa T ( s obzirom da T moze da bude i klasni tip ), 
 a vraca true ili false u zavisnosti da li objekat zadovoljava uslov za
 ostanak u kolekciji ili ne */
template <typename Kol, typename T>
void transformisi(Kol &k, bool (*u)(T&)){
	/* prolazimo kroz kolekciju */	
	for(typename Kol::iterator it = k.begin(); it!=k.end();){
		/* na element kolekcije primenjujemo unarni uslov
		 i u slucaju da on nije ispunjen element brisemo */
		if(!u(*it))
			it = k.erase(it); // brise element kolekcije na koji pokazuje it i vraca iterator 
					// na sledeci element kolekcije (iza obrisanog)	
		else
			it++; // ako element ostavljamo u kolekciji, samo pomeramo iterator na sledeci
					
	}
}

/* definisemo uslov da je element deljiv sa 3 */
template <typename T>
bool Div3(const T& x){
	return x%3==0;
}
/* definisemo uslov da element nije deljiv sa 5 */
template <typename T>
bool NotDiv5(const T& x){
	return x%5!=0;
}
/* definisemo uslov da je element veci od 7 */
template <typename T>
bool Gre7(const T& x){
	return x>7;
}

/* definisemo uslov da je element manji od 11 */
template <typename T>
bool Less11(const T& x){
	return x<11;
}


/* drugi nacin je da jos uopstimo ove uslove, tako sto uvedemo dodatni parametar 
koji prosledjujemo prilikom instanciranja sablona
na primer: Div<3, int>, NotDiv<5, int>, Gre<7, int>, Less<11, int> 

ipak, vodite racuna da se sabloni staticki instanciraju, pa nije moguce nesto ovako: 
Div<i, int> gde je i promenljiva u programu koja dobija vrednost tokom izvrsavanja programa
*/
template <int delilac, typename T>
bool Div(const T& x){
	return x%delilac==0;
}

template <int delilac, typename T>
bool NotDiv(const T& x){
	return x%delilac != 0;
}

template <int poredbenik, typename T>
bool Gre(const T& x){
	return x>poredbenik;
}

template <int poredbenik, typename T>
bool Less(const T& x){
	return x<poredbenik;
}

int main(){
	unsigned n;
	cout<<"Unesite broj elemenata niza:"<<endl;
	cin >> n;
	std::vector<int> v1;
	cout<<"Unesite niz celih brojeva:"<<endl;
	ucitaj< std::vector<int>, int>(v1,n);
	cout<<"Uneli ste niz:"<<endl;
	ispis(v1);
	cout<<"Niz nakon izmene (svi deljivi sa 3):"<<endl;
	transformisi(v1, Div<3,int>); // ili sa: transformisi(v1, Div3<int>);
	ispis(v1);

	cout<<"Unesite broj elemenata niza:"<<endl;
	cin >> n;
	std::vector<int> v2;
	cout<<"Unesite niz celih brojeva:"<<endl;
	ucitaj< std::vector<int>, int>(v2,n);
	cout<<"Uneli ste niz:"<<endl;
	ispis(v2);
	cout<<"Niz nakon izmene (svi nedeljivi sa 5):"<<endl;
	transformisi(v2, NotDiv<5, int>); // ili sa: transformisi(v2, NotDiv5<int>); 
	ispis(v2);
	
	cout<<"Unesite broj elemenata liste:"<<endl;
	cin >> n;
	std::list<double> l1;
	cout<<"Unesite listu realnih brojeva:"<<endl;
	ucitaj< std::list<double>, double>(l1,n);
	cout<<"Uneli ste listu:"<<endl;
	ispis(l1);
	cout<<"Lista nakon izmene (svi veci od 7):"<<endl;
	transformisi(l1, Gre<7,double>); // ili sa: transformisi(l1, Gre7<double>);
	ispis(l1);

	cout<<"Unesite broj elemenata liste:"<<endl;
	cin >> n;
	std::list<double> l2;
	cout<<"Unesite listu realnih brojeva:"<<endl;
	ucitaj< std::list<double>, double>(l2,n);
	cout<<"Uneli ste listu:"<<endl;
	ispis(l2);
	cout<<"Lista nakon izmene (svi manji od 11):"<<endl;
	transformisi(l2, Less<11, double>); // ili sa: transformisi(l2, Less11<double>);
	ispis(l2);

}
