#include <iostream>
#include <vector>
#include <algorithm>

using std::cout;
using std::cin;
using std::endl;

/* sablon za ispis proizvoljne kolekcije */
template <typename Kol>
void ispis(const Kol &k){
	for(typename Kol::const_iterator it=k.begin(); it!=k.end(); it++){
		cout<< *it << " ";
	}
	std::cout << std::endl;
}

/* sablon za ucitavanje proizvoljne kolekcije, kolekcija tipa Kol kao elemente ima objekte tipa T */
template <typename Kol, typename T>
void ucitaj(Kol &k, int n){
	T x;
	for(int i=0; i<n; i++){
		cin>>x;
		k.push_back(x);
	}
}

/*
Klasa Veci sadrži preopterećenje funkcijskog operatora (). 
On kao parametre prima dva cela broja i vraća informaciju da li je 
prvi broj veći od drugog. Primenu funkcijskog objekta ove klase 
prikazujemo pri pozivu metode sort za drugu polovinu vektora.
*/
class Veci{
    public:
        bool operator()(int a, int b){
            return a > b;
        }
};

int main(){
	unsigned n;
	cout<<"Unesite broj elemenata vektora (mora biti paran):"<<endl;
	cin >> n;
	std::vector<int> v1;
	cout<<"Unesite vektor celih brojeva:"<<endl;
	ucitaj< std::vector<int>, int>(v1,n);
	cout<<"Uneli ste vektor:"<<endl;
	ispis(v1);

    /*
        funkcija sort iz zaglavlja algorithm
        prva dva argumenta su iteratori na pocetak i kraj 
        kolekcije koja se sortira (po potrebi se moze sortirati 
        proizvoljan deo kolekcije, modifikovanjem iteratora)

        podrazumevano se sortira rastuce primenom operatora < 

        ako zelimo da promenimo nacin sortiranja, kao treci 
        argument prosledjujemo kriterijum za sortiranje

        primer sortiranja celog vektora rastuce
        sort(v1.begin(), v1.end())
    */
    // sortiramo prvu polovinu pa je drugi argument 
    // iterator na prvi element desno od sredisnjeg (on se ne uzima u obzir)
    sort(v1.begin(), v1.begin()+n/2, [](int a, int b){return a>b;});
    /*
        kriterijum za sortiranje je definisan lambda funkcijom

        [](int a, int b){return a>b;}

        [] - klauzula hvatanja (capture clause)
        (int a, int b) - lista parametara 
        {return a>b;} - telo lambda funkcije  

    */
    cout<<"Vektor nakon sortiranja prve polovine opadajuce:"<<endl;
	ispis(v1);
    
    // prosledjujemo privremeni funkcijski objekat klase Veci
    // njegov funkcijski operator () ima dva ulazna parametra i 
    // pri svakom pozivu funkcijskog objekta Veci metoda sort će 
    // njegovom funkcijskom operatoru predati dva podatka koja treba 
    // uporediti, a on će vratiti koji od njih je veći
    sort(v1.begin()+n/2, v1.end(), Veci());
    cout<<"Vektor nakon sortiranja druge polovine opadajuce:"<<endl;
	ispis(v1);
}
