#include <iostream>
#include <vector>
#include "Lin.h"

using std::cout;
using std::cin;
using std::endl;


/* sablon za ispis proizvoljne kolekcije */
template <typename Kol>
void ispis(const Kol &k){
	for(typename Kol::const_iterator it=k.begin(); it!=k.end(); it++){
		cout<< *it << " ";
	}
	std::cout << std::endl;
}

/* sablon za ucitavanje proizvoljne kolekcije, kolekcija tipa Kol kao elemente ima objekte tipa T */
template <typename Kol, typename T>
void ucitaj(Kol &k, int n){
	T x;
	for(int i=0; i<n; i++){
		cin>>x;
		k.push_back(x);
	}
}

/* sablon kojim prebrojavamo koliko elemenata date kolekcije zadovoljava uslov predstavljen funkcionalom f i dodatno 
takve elemente ispisujemo */
template <typename Kol, typename Funkcional>
int prebroj(Kol &k, const Funkcional &f){
	int broj = 0;
	for(typename Kol::iterator it = k.begin(); it!=k.end();it++){
		if(f(*it)){
			cout << *it << " ";
			broj++;
		}
	}
	cout<<endl;
	return broj;
}

int main(){
	unsigned n;
	cout<<"Unesite broj elemenata niza:"<<endl;
	cin >> n;
	std::vector<int> v1;
	cout<<"Unesite niz celih brojeva:"<<endl;
	ucitaj< std::vector<int>, int>(v1,n);
	cout<<"Uneli ste niz:"<<endl;
	ispis(v1);
	double a, b;
	cout<<"Unesite koeficijente linearne jednacine:"<<endl;
	cin >> a >> b;
	funkcional::Linear<int> funkLin(a, b);
	cout<<"Trazimo nule jednacine " << a << " * x + " << b << endl;
	int broj = prebroj(v1, funkLin);
	if(broj == 0)
		cout<<"U kolekciji nema nula date jednacine "<< endl;
	else
		cout<<"Ukupno je pronadjeno "<< broj << " nula." << endl;

	cout<<"Unesite broj elemenata niza:"<<endl;
	cin >> n;
	std::vector<double> v2;
	cout<<"Unesite niz realnih brojeva:"<<endl;
	ucitaj< std::vector<double>, double>(v2,n);
	cout<<"Uneli ste niz:"<<endl;
	ispis(v2);
	cout<<"Unesite koeficijente linearne jednacine:"<<endl;
	cin >> a >> b;
	funkcional::Linear<double> funkLin2(a, b);
	cout<<"Trazimo nule jednacine " << a << " * x + " << b << endl;
	broj = prebroj(v2, funkLin2);
	if(broj == 0)
		cout<<"U kolekciji nema nula date jednacine "<< endl;
	else
		cout<<"Ukupno je pronadjeno "<< broj << " nula." << endl;
}
