#include<iostream>
#include<vector>
#include<string>
#include<algorithm>

using std::cout;
using std::cin;
using std::endl;

/* 
	template <class ForwardIterator, class UnaryPredicate, class T>
  	void replace_if (ForwardIterator first, ForwardIterator last,
                   UnaryPredicate pred, const T& new_value );

Sablon replace_if (https://www.cplusplus.com/reference/algorithm/replace_if/) iz biblioteke algorithm postavlja novu vrednost new_value svim elementima na koje pokazuju iteratori iz ranga [first, last), a za koje je predikat pred vratio true, odnosno za koje je ispunjen neki uslov.
 
*/


/* predikat dopuna kao argument ima element nase kolekcije, tj. raspolozivu kolicinu za jednu vrstu artikla */
bool dopuna(double kolicina){
	if(kolicina < 100)
		return true;
	else
		return false;

}

/* implementacija sablona replace_if, nema povratnu vrednost */
template<class Iterator, class Predikat, class T>
void klon_replace_if(Iterator pocetak, Iterator kraj, Predikat p, const T& nova_vrednost){
	while(pocetak!=kraj){
		// proveravamo ispunjenost uslova za tekuci artikal 
		if(p(*pocetak))
			// postavljamo novu kolicinu za artikal
			*pocetak= nova_vrednost; 
		++pocetak;
	}
}

int main(){
	
	int n; 
	cout<<"Unesite koliko vrsta artikala ima prodavnica:"<<endl;
	cin>>n;
	// vektor za cuvanje imena artikala 
	std::vector<std::string> artikli;
	// vektor za cuvanje raspolozive kolicine za artikle 
	std::vector<double> kolicine;
	cout<<"Unesite imena artikala:"<<endl;
	for(int i=0;i<n;i++){
			std::string ime;
			cin >> ime;
			artikli.push_back(ime);
	}
	cout<<"Unesite raspolozive kolicine za sledece artikle:"<<endl;
	for(int i=0;i<n;i++){
			cout << artikli[i] << " - ";
			double k;
			cin >> k;
			kolicine.push_back(k);
	}
	std::vector<std::string>::const_iterator ait;
	std::vector<double>::const_iterator kit;
	cout << "Raspolozivi artikli:" << endl;
	for(ait = artikli.begin(), kit = kolicine.begin(); ait!=artikli.end(); ait++, kit++)
		cout << "Artikal: " << *ait << ", na stanju: "<< *kit << endl;
	// upotreba sablona replace_if iz biblioteke algorithm:
	//std::replace_if(kolicine.begin(), kolicine.end(), dopuna, 100);

	klon_replace_if(kolicine.begin(), kolicine.end(), dopuna, 100);
	cout << "Raspolozivi artikli - posle dopune:" << endl;
	for(ait = artikli.begin(), kit = kolicine.begin(); ait!=artikli.end(); ait++, kit++)
		cout << "Artikal: " << *ait << ", na stanju: "<< *kit << endl;
}
