#ifndef FUN_H
#define FUN_H

namespace funkcional{

/* Kada unapred znamo koji to uslov treba proveriti mozemo koristiti sablone sa odgovarajucim parametrima 
koji imaju ulogu neke osnove koju taj unarni uslov koristi (kao u prethodnom primeru delilac, poredbenik ...) 
i tipa objekta za koji se uslov poziva, medjutim, i dalje ne mozemo od korisnika da trazimo da unese vrednost 
parametra osnova, pa da onda pozovemo odgovarajucu instancu uslov<osnova, T>. 
 
Potpuno dinamicko resenje koje bi nam omogucilo da korisnik u fazi izvrsavanja parametrizuje taj unarni uslov
je koriscenje funkcionala. Programski jezik C++ dopusta da se u klasi definise operator () sa proizvoljnim brojem 
argumenata i sa proizvoljnim tipom rezultata. Objekte klase koja ima definisan ovaj operator nazivamo 
funkcionalima i mozemo ih koristiti kao funkcije koje nesto izracunavaju. 

*/


/* Objekte klase Div mozemo da koristimo kao unarne uslove za proveru deljivosti nekog objekta sa clanom deliocem */ 
template < typename T>
class Div{
	public:
		Div(int d){
			_delilac=d;
		}
		bool operator()(const T& x) const{
			return !(x%_delilac);
		}
	private:
		int _delilac;
};


/* Objekte klase Gre mozemo da koristimo kao unarne uslove za poredjenje nekog objekta sa clanom deliocem */ 
template < typename T>
class Gre{
	public:
		Gre(int p){
			_poredbenik=p;
		}
		bool operator()(const T& x) const{
			return x > _poredbenik;
		}
	private:
		double _poredbenik;
};

}

#endif
