#include <iostream>
#include <vector>


/* Kontejneri (ili kolekcije) predstavljaju klase koje omogucavaju cuvanje
 kolekcija objekata odredjenog (unapred zadatog) tipa. Biblioteka C++-a
 sadrzi tzv. Standardnu biblioteku sablona (eng. Standard Template Library,
 poznato pod nazivom STL).Svi kontejneri su sablonske klase, parametrizovane
 tipom podataka koji ce se cuvati u kontejneru. Postoje sekvencijalni i 
 asocijativni kontejneri. Za svaki kontejner treba ukljuciti zaglavlje koje 
 nosi isto ime kao i sam kontejner (npr. <vector>, <list> i sl.).
 
 Sekvencijalni kontejneri cuvaju elemente u obliku uredjene sekvence, gde 
 svaki element ima svoju poziciju u kontejneru koju korisnik sam odredjuje 
 nacinom i poretkom dodavanja elemenata. Pored sekvencijalnih, postoje i 
 asocijativni kontejneri koji se zasnivaju na kljucevima koje je moguce 
 efikasno pretrazivati.
 
 Svi kontejneri imaju metode begin() i end(). Prva vraca iterator na pocetni 
 element, dok druga vraca invalidni iterator na zamisljeni nepostojeci
 element koji sledi nakon poslednjeg elementa. Ovaj iterator koji vraca end() 
 se dobija nakon sto se primeni ++ operator na iterator koji pokazuje na poslednji element,
 pa je zgodan u uslovu petlje kada se prolazi kroz kontejner (it != v.end()).
 
 Takodje, funcija find() koja pretrazuje kontejner vraca taj iterator ako
 u kontejneru ne postoji trazeni element. 
 
 Iteratori podrzavaju sledece operacije:
 *it -- vraca referencu na element na koji trenutno pokazuje
 it++ (++it) -- pomera se na sledeci element u kontejneru
 it-- (--it) -- pomera se na prethodni element u kontejneru (neuredjeni asocijativni
 kontejneri ne podrzavaju ovu operaciju)
 it1 == it2 -- provera da li iteratori pokazuju na isti element
 it1 != it2 -- provera da li iteratori pokazuju na razlicite elemente
 
 Iteratori u kontejnerima sa indeksnim pristupom (vector, deque) podrzavaju i sledece:
 it + n (iterator koji pokazuje na element n pozicija udesno u odnosu na element na koji pokazuje it)
 it - n (slicno, samo ulevo)
 it += n, it -= n (kombinacija prethodna dva sa dodelom)
 it1 - it2 (ako it1 i it2 pokazuju na elemente u istom kontejneru, tada je rezultat rastojanje 
 izmedju elemenata na koje pokazuju)
 it1 < it2, it1 > it2, it1 <= it2, it1 >= it2 (prvi slucaj znaci da it1 pokazuje na element u 
 kontejneru pre elementa na koji pokazuje it2, ostalo analogno)
 it[n]  (ekvivalentno sa *(it + n))

 Sekvencijalni kontejner:
 
 vector<T> -- u pitanju dinamicki niz elemenata tipa T. Vektor ima: 
 velicinu (vraca je metod size()) koja predstavlja broj elemenata u 
 vektoru u tom trenutku, i kapacitet (vraca ga metod capacity()) koji je
 veci ili jednak od velicine i predstavlja za koliko je elementa u ovom 
 trenutku alociran prostor. Metod resize(n) omogucava promenu velicine 
 vektora. Ako je n manje od tekuce velicine, tada se vektor skracuje, tako
 sto se brisu elementi sa kraja vektora (prostor se ne dealocira, samo se
 vise ne koristi, ali ostaje tu za kasnija prosirenja). Ako je n vece od
 tekuce velicine, velicina vektora se povecava (uz realokaciju, ako je 
 potrebna), a novododati elementi se inicijalizuju podrazumevanim vrednostima
 (0 za primitivne tipove, podrazumevani konstruktor za klasne tipove). 
 Vektor ima ugradjen operator [] kojim se moze pristupati proizvoljnom 
 elementu na efikasan nacin (kao i kod obicnih nizova). Podrzava efikasno 
 dodavanje elemenata na kraj, kao i brisanje elemenata sa kraja */

int main(){
	
	/* Kreiramo prazan vektor int-ova */
	std::vector<int> v; 
	
	/* Konstruktor:
	 * 
	 * std::vector<int> v(10);
	 * 
	 * bi kreirao vektor od 10 elemenata inicijalizovanih na 0, dok bi
	 * konstruktor:
	 * 
	 * std::vector<int> v(10, 5);
	 * 
	 * kreirao vektor od 10 int-ova inicijalizovanih vrednoscu 5. 
	 * 
	 */
	int n;
	std::cin >> n;
	while(n!=0){
		v.push_back(n); // dodaje element na kraj vektora, pri cemu se vektor produzava za jedan
		std::cin >> n;
	}	
	if(v.size()!=0){
		/* Pomocu iteratora ispisujemo ucitane elemente, s obzirom da ne modifikujemo vektor
		 koristimo const_iterat*or */
		std::vector<int>::const_iterator it;
		std::cout << "Uneli ste brojeve:" << std::endl;
		for(it = v.begin(); it != v.end(); it++){
			std::cout << *it << " ";
		}
		std::cout << std::endl;
		/* Koristimo reverse iterator za ispis svakog treceg elementa pocev od poslednjeg */
		std::vector<int>::const_reverse_iterator rit;
		std::cout << "Svaki treci element pocev od poslednjeg:" << std::endl;
		/* I nacin:
		int i;
		for(i = 0, rit = v.rbegin(); rit != v.rend(); rit++, i++){
			if(i%3==0)
				std::cout << *rit << " ";
		}
		std::cout << std::endl;
		*/
		// II nacin: koriscenjem relacionog operatora nad iteratorima
		// obratiti paznju na uslov rit < v.rend()
		for(rit = v.rbegin(); rit < v.rend(); rit+=3)
			std::cout << *rit << " ";
		
		std::cout << std::endl;
	}
	else
		std::cout << "Niste uneli nijedan broj." << std::endl;
	
}	
	
