# modul QtWidgets sadrzi klase za razlicite kontrolne elemente
from PyQt5 import QtWidgets

"""
Pravimo klasu koja nasledjuje klasu QWidget koja 
prestavlja osnovni kontrolni element - prozor aplikacije

Definicija klase:

class ImeKlase(KlasaKojaSeNasledjuje):
    definicija metoda klase

Medju metodima izdvaja se __init__ metod
koji sluzi za inicijalizaciju instance klase.
U okviru tog metoda definisemo polja podatke klase.

"""

class GUI(QtWidgets.QWidget):
    def __init__(self):
        # pozivamo metod za inicijalizaciju 
        # iz roditeljske klase
        super().__init__()
        # ostale postavke su izvojene u metodu radi preglednijeg koda
        self.setupUI()
    
    # self je referenca na instancu klase
    def setupUI(self):
        """
        Svaki program se (pojednostavljeno) moze podeliti na 3 faze:
            - postavljanje samog prozora
            - postavljanje komponenti
            - postavljane konekcija
        Radi preglednijeg koda ovo cemo izdvojiti u zasebne metode
        """
        layout = self.setupWindow(title="Konvertor", size = 300)
        self.setupComponents(layout)
        self.setupConnections()

    def setupWindow(self, title, size, spacing = 20):
        self.setWindowTitle(title)
        width, height = size, size
        # prva dva argumenta su koordinate gornjeg levog ugla prozora
        # poslednja dva argumenta su dimenzije prozora
        # da bi se centar prozora nalazio u koordinatnom pocetku prozora
        # gornji levi cosak postavljamo na pola sirine i visine
        # NAPOMENA: u grafickim aplikacijama x osa se uvecava u levo (kao i matematicki koordinatni sistem)
        # ali se y osa povecava na dole (suprotno od matematickog koordinatnog sistema)
        self.setGeometry(-width//2, -height//2, width, height)

        # koristimo tabelarnu organizaciju i vracamo tu organizaciju
        # da bi kasnije mogli da dodajemo elemente u nju
        layout = QtWidgets.QGridLayout()
        layout.setSpacing(spacing)
        self.setLayout(layout)
        return layout


    def setupComponents(self, layout):
        # komponenta za unos jednolinijskog teksta
        self.lineEdit = QtWidgets.QLineEdit()
        self.lineEdit.setText("0")
        # dodajemo u tabelu
        # pozicija komponente je 0, 0 -> prva vrsta i kolona
        # komponenta se prostire u jednoj vrsti i dve kolone -> 1, 2
        layout.addWidget(self.lineEdit, 0, 0, 1, 2)

        # dugme
        self.buttonEUR = QtWidgets.QPushButton()
        self.buttonEUR.setText("EVRI")
        layout.addWidget(self.buttonEUR, 1, 0)

        self.buttonRSD = QtWidgets.QPushButton("Dinari")
        layout.addWidget(self.buttonRSD, 1,1)
    
    def setupConnections(self):
        # za signal vezujemo funkciju -> odgovor na signal
        # convertEUR je funkcija koja ce se izvrsiti kada se klikne na dugme
        self.buttonEUR.clicked.connect(self.convertEUR)
        self.buttonRSD.clicked.connect(self.convertRSD)

    def convertEUR(self):
        text = self.lineEdit.text()
        try:
            money = float(text)
        except ValueError:
            self.error(f"Nevalidna vrednost: {text}")
            return
        money /= 117.5
        self.lineEdit.setText(f"{money:.2f}")
    
    def convertRSD(self, f):
        text = self.lineEdit.text()
        # ukoliko je neispravna vrednost 
        # konverzija u float ce izbaciti izuzetak
        try:
            money = float(text)
        except ValueError:
            self.error(f"Nevalidna vrednost: {text}")
            return
        money *= 117.5
        self.lineEdit.setText(f"{money:.2f}")
    
    def error(self, message):
        # pravimo prozor za prikaz poruke korisniku
        alert = QtWidgets.QMessageBox()
        alert.setWindowTitle("Greska")
        alert.setText(message)
        # da bi se pokrenuo event loop
        # tj. da bi se sacekala akcija od strane korisnika 
        # pre nego se iskljuci prozor
        alert.exec_()
    
# pravimo instancu koja predstavlja aplikaciju
app = QtWidgets.QApplication([])
# inicijalizujemo prozor aplikacije
window = GUI()
# prikazujemo prozor aplikacije
# show pravi sve komponente u memoriji i prikazuje prozor aplikacije
window.show()
# pokretanje main event loop-a
# kako bi se sacekala akcija od strane korisnika
app.exec_()