import warnings
warnings.filterwarnings('ignore')

import pandas as pd
from matplotlib import pyplot as plt

'''
Zadatak:
    Izdvojiti sve tacke, podeliti ih po bojama,
    Za svaku boju naci centroid i dodati u skup
    I za svaku tacku dodati informaciju o udaljenosti od koordinatnog pocetka
    Sacuvati svaku boju kao poseban CSV
'''



# Prvo moramo ukloniti sve redove koji nemaju vrednos za boju
# CSV format ima predefinisane vrednosi za nepostojecu vrednost
# (None, Nan, prazna kolona...)
tacke = pd.read_csv("tacke.csv")
tacke.dropna(subset=["Color"], inplace=True)

# Crtamo grafih svih tacaka koje imaju boju
plt.scatter(tacke["x"], tacke["y"], color=tacke["Color"])
plt.show()

# Hocemo da nadjemo koje boje postoje u nasem skupu
colors = tacke["Color"].drop_duplicates()

for color in colors:
    tacke_color = tacke.query(f"Color == '{color}'")
    # moze i bez query:
    # tacke_color = tacke[tacke["Color"] == color]

    # kolona za boju nam vise ne treba posto ce se
    # podatak o boji nalaziti u imenu fajla
    tacke_color.drop(columns=["Color"], inplace=True)

    # racunamo centroid
    centx = tacke_color["x"].sum() / tacke_color["x"].count()
    centy = tacke_color["y"].sum() / tacke_color["y"].count()
    
    # posto ne postoji nacin da se samo doda element u DataFrame
    # dodavanje se postize tako sto se napravi novi DataFrame sa svim elementima koje zelimo da dodamo
    # i onda spojimo trenutni i novi DataFrame u 1
    centroid = pd.DataFrame([["Centroid", centx, centy]], columns = ["Point", "x", "y"])
    tacke_color = pd.concat([tacke_color, centroid])

    # dodajemo kolonu za udaljenost od koordinatnog pocetka
    tacke_color["distance"] = (tacke_color["x"]**2 + tacke_color["y"]**2) ** 0.5
    
    # cuvamo csv
    tacke_color.to_csv(f"tacke_{color}.csv", index=False)