package main

import (
	"fmt"
	"math"
	"math/rand"
	"time"
)

type Krug struct{ R int }

func (k Krug) obim() float64 {
	return 2 * math.Pi * float64(k.R)
}

func main() {
	// generator pseudo-slucajnih brojeva
	// zadaje mu se vrednost seed-a
	// ako je seed fiksne vrednosti - isto se generise pri svakom pokretanju programa
	// probati sa:
	// r := rand.New(rand.NewSource(100))

	// ako zelimo da generisane vrednosti budu drugacije pri svakom pokretanju
	// mozemo koristi podatke o tekucem vremenu za seed
	r := rand.New(rand.NewSource(time.Now().UnixNano()))
	/*
		for petlja:

		for inicijalizacija; uslov; inkrement{
			blok naredbi
		}
	*/
	for i := 0; i < 10; i++ {
		// Intn generise pseudo-slucajan broj iz intervala [0,n)
		k := Krug{r.Intn(10) + 1}
		fmt.Printf("Obim kruga poluprecnika %d je %f\n", k.R, k.obim())
	}
}
