// a)
package main

import (
	"fmt"
	"runtime"
	"sync"
)

/* Za sinhronizaciju cemo koristiti tip WaitGroup
iz paketa sync koji predstavlja vid barijere koji
ceka na zavrsavanje grupe gorutina */
var wg sync.WaitGroup

// da bismo obezbediti kozistentnost deljenih podataka
// koristimo katanac
var mutex sync.Mutex

// deljeni podaci
var vektor []int
var n int // dimenzija vektora
var i int // index elementa koji se mnozi skalarom
var skalar int

// definisemo funkciju za mnozenje odgovarajuceg elementa vektora
// argument je redni broj kreirane gorutine
func mnozenje(rb int) {
	/* kriticna sekcija je deo koda u kome nit
	pristupa zajednickim podacima
	potrebno je obezbediti da vise niti ne moze
	istovremeno izvrsavati kriticnu sekciju

	jedan od mehanizama za sinhronizaciju je tip Mutex
	odnosno, katanac kojim se zakljucava/otkljucava
	kriticna sekcija */
	var index int // lokalna kopija podatka i
	for {
		// zakljucavanje kriticne sekcije
		mutex.Lock()
		// provera da li se doslo do kraja vektora
		if i == n {
			mutex.Unlock()
			break
		} else {
			// cuvamo kopiju i azuriramo podatak
			index = i
			i += 1
		}
		// zavrsili obradu deljenog podatka
		// otkljucavamo sekciju
		mutex.Unlock()
		fmt.Printf("Gorutina %d mnozi el. na poziciji %d\n", rb, index)
		vektor[index] *= skalar
	}
	// svaka gorutina na kraju svog izvrsavanja poziva metod Done
	wg.Done()
}

func main() {
	// ucitavamo podatke
	fmt.Scanf("%d", &n)
	vektor = make([]int, n)
	for i := 0; i < n; i++ {
		fmt.Scanf("%d", &vektor[i])
	}
	fmt.Println(vektor)
	fmt.Scanf("%d", &skalar)

	// broj gorutina definisemo u skladu sa mogucnostima sistema
	brojGR := runtime.NumCPU()
	/* Pre nego sto se gorutine kreiraju potrebno je pozvati metod Add(broj)
	argument je broj gorutina koji je potrebno sacekati */
	wg.Add(brojGR)
	for rg := 0; rg < brojGR; rg++ {
		go mnozenje(rg)
	}
	// pozivanjem metoda Wait, tekuca gorutina se
	// blokira i ceka na zavrsetak rada svih gorutina
	wg.Wait()
	fmt.Println(vektor)
}
