// Primer demonstrira da nije uvek neophodno cekati da sve niti zavrse
// Pokusavamo da nadjemo sve parove uzajamno prostih brojeva iz niza
// Medjutim, ukoliko je veci broj prost, onda nista ne mora da se racuna,
// sigurno su uzajamno prosti (ovaj uslov bi jos mogao da se razradi, uradjena
// je samo najjednostavnija varijanta kao primer).
// Dakle, imamo 2 procesa: proces koji racuna parove uzajamno prostih (ovo nam je
// bitno i cekamo) i racuna proste brojeve (ovo je pomocno izracunavanje i apsulutno
// nam nije bitno da zavrsi, mozemo izracunati parove bez da proverimo i jedan broj da
// li je prost)

package main

import (
	"fmt"
	"math"
	"os"
	"runtime"
	"slices"
	"sync"
)

var n int
var niz []int

func gcd(a, b int) int {
	if b == 0 {
		return a
	} else {
		return gcd(b, a%b)
	}
}

func isPrime(n int) bool {
	if n < 2 {
		return false
	} else if n == 2 {
		return true
	} else if n%2 == 0 {
		return false
	}

	for i := 3; i < int(math.Sqrt(float64(n))); i += 2 {
		if n%i == 0 {
			return false
		}
	}

	return true
}

var prosti []int

var primeMutex sync.Mutex
var primeMutexCurrent sync.Mutex

var primeCurrent int

func workerPrime(c chan int) {
	for {
		primeMutexCurrent.Lock()
		if primeCurrent == n {
			primeMutexCurrent.Unlock()
			break
		} else {
			primeCurrent++
			primeMutexCurrent.Unlock()
		}

		broj := <-c
		if isPrime(broj) {
			primeMutex.Lock()
			// varijanta gde sve proste brojeve pisemo u niz je neefikasna
			// za vezbu se ovo moze optimizovati (na primer, mozemo cuvati
			// niz bool vrednosti gde su podrazumevano sve false, i onda kako
			// kako nadjemo neki prost broj, njegovu poziciju u pomocnom nizu
			// promenimo na true)
			prosti = append(prosti, broj)
			primeMutex.Unlock()
		}
	}
}

type pair struct {
	a     int
	b     int
	valid bool
}

var wg sync.WaitGroup

func workerGcd(c chan pair) {
	for {
		par := <-c

		if !par.valid {
			c <- par
			break
		}

		primeMutex.Lock()
		// Primer je uradjen neefikasno da bi se pokazao paket slices
		// Gore navedena optimizacija bi bila bolja upravo zbog ovoga:
		// Obilazimo ceo niz
		if slices.Contains(prosti, par.a) {
			fmt.Printf("Brojevi %v i %v su uzajamno prosti!\n", par.a, par.b)
			primeMutex.Unlock()
			continue
		}
		primeMutex.Unlock()

		if gcd(par.a, par.b) == 1 {
			fmt.Printf("Brojevi %v i %v su uzajamno prosti\n", par.a, par.b)
		}
	}

	wg.Done()
}

func main() {
	numWorkers := runtime.NumCPU()
	numPrimeWorkers := 2
	numGcdWorkers := numWorkers - numPrimeWorkers

	file, err := os.Open("brojevi.txt")
	if err != nil {
		fmt.Println("Greska prilikom otvaranja datoteke")
		// prekidamo program
		os.Exit(1)
	}
	fmt.Fscanf(file, "%d\n", &n)

	primeC := make(chan int, n)

	for i := 0; i != numPrimeWorkers; i++ {
		go workerPrime(primeC)
	}

	for i := 0; i != n; i++ {
		var broj int
		fmt.Fscanf(file, "%d\n", &broj)
		primeC <- broj
		niz = append(niz, broj)
	}

	gcdC := make(chan pair, numGcdWorkers)
	wg.Add(numGcdWorkers)
	for i := 0; i != numGcdWorkers; i++ {
		go workerGcd(gcdC)
	}

	for _, a := range niz {
		for _, b := range niz {
			if a > b {
				gcdC <- pair{a, b, true}
			}
		}
	}
	gcdC <- pair{valid: false}
	wg.Wait()
}
