{-
 odabir protivnika i rezima
-}

main = do putStrLn "Odaberi igru:"
          putStrLn "1. Igrac protiv igraca"
          putStrLn "2. Igrac protiv racunara"
          protivnik <- ucitaj
          putStrLn "Odaberi rezim:"
          putStrLn "1. Gomila"
          putStrLn "2. Nizovi"
          rezim <- ucitaj
          igra protivnik rezim [0,0] [0,0] 1

brojKuglica = 15
nizKuglica = [1,2,3,4,5]
brojRedova = (duzina nizKuglica 0)

{-
 inicijalizacija igre
-}		 
igra x y i1 i2 igrac = if x == 1 then 
                          if y == 1 then (do putStrLn "Odabrano: Igrac protiv igraca. Gomila." 
                                             if igrac == 1 then 
                                                  gIgrac1 brojKuglica i1 i2
                                             else 
                                                  gIgrac2 brojKuglica i1 i2)
                          else 
                              (do putStrLn "Odabrano: Igrac protiv igraca. Niz."
                                  if igrac == 1 then
                                    nIgrac1 nizKuglica i1 i2
                                  else
                                    nIgrac2 nizKuglica i1 i2)
                       else 
                          if y == 1 then (do putStrLn "Odabrano: Igrac protiv racunara. Gomila."
                                             if igrac == 1 then 
                                                  gIgrac brojKuglica i1 i2
                                             else 
                                                  gRacunar brojKuglica i1 i2)
                          else
                              (do putStrLn "Odabrano: Igrac protiv racunara. Niz."
                                  if igrac == 1 then
                                    nIgrac nizKuglica i1 i2
                                  else
                                    nRacunar nizKuglica i1 i2)

{-
 rezim gomila, na potezu Igrac1
-}					  
gIgrac1 brkuglica i1 i2 = if brkuglica == 0 then 
                          do putStrLn "***********************************************"
                             putStrLn "Pobednik je Igrac2."
                             putStrLn ("Trenutni rezultat:\nGomila: " 
                                       ++ show ((prvi i1) :: Int) 
                                       ++ "-" ++ show (((prvi i2)+1) :: Int)
                                       ++ "\nNiz: " ++ show ((poslednji i1) :: Int)
                                       ++ "-" ++ show ((poslednji i2) :: Int))
                             putStrLn "***********************************************"
                             let i = uvecaj i2 1 1 1
                             josI2 i1 i
                         else do putStrLn "***********************************************"
                                 putStrLn  "Preostalo kuglica: " 
                                 print (brkuglica) 
                                 putStrLn "Na potezu Igrac1."
                                 x <- unesi brkuglica
                                 gIgrac2 (brkuglica-x) i1 i2

{-
 rezim gomila, na potezu Igrac2
-}					  
gIgrac2 brkuglica i1 i2 = if brkuglica == 0 then 
                          do putStrLn "***********************************************"
                             putStrLn "Pobednik je Igrac1."
                             putStrLn ("Trenutni rezultat:\nGomila: " 
                                       ++ show (((prvi i1)+1) :: Int)
                                       ++ "-" ++ show ((prvi i2) :: Int)
                                       ++"\nNiz: " ++ show ((poslednji i1) :: Int)
                                       ++ "-" ++ show ((poslednji i2) :: Int))
                             putStrLn "***********************************************"
                             let i = uvecaj i1 1 1 1
                             josI1 i i2
                         else do putStrLn "***********************************************"
                                 putStrLn  "Preostalo kuglica: " 
                                 print (brkuglica) 
                                 putStrLn "Na potezu Igrac2."
                                 x <- unesi brkuglica
                                 gIgrac1 (brkuglica-x) i1 i2

{-
 rezim niz, na potezu Igrac1
-}                                   
nIgrac1 l i1 i2 = if (prazna l) == 1 then 
                      do putStrLn "***********************************************"
                         putStrLn "Pobednik je Igrac2."
                         putStrLn ("Trenutni rezultat:\nGomila: " 
                                   ++ show ((prvi i1) :: Int) 
                                   ++ "-" ++ show ((prvi i2) :: Int)
                                   ++ "\nNiz: " ++ show ((poslednji i1) :: Int)
                                   ++ "-" ++ show (((poslednji i2)+1) :: Int))
                         putStrLn "***********************************************"
                         let i = uvecaj i2 1 2 1
                         josI2 i1 i
	              else do putStrLn "***********************************************"
	                      putStr "Trenutno stanje:"
	                      iscrtavanje l brojRedova 
	                      putStrLn "Na potezu Igrac1."
	                      poz <- unesiPoziciju l
	                      br <- unesiKuglice l poz
	                      nIgrac2 (zameni l br poz 1) i1 i2

{-
 rezim niz, na potezu Igrac2
-}                          
nIgrac2 l i1 i2 = if (prazna l) == 1 then 
                      do putStrLn "***********************************************"
                         putStrLn "Pobednik je Igrac1."
                         putStrLn ("Trenutni rezultat:\nGomila: " 
                                   ++ show ((prvi i1) :: Int)
                                   ++ "-" ++ show ((prvi i2) :: Int)
                                   ++"\nNiz: " ++ show (((poslednji i1)+1) :: Int)
                                   ++ "-" ++ show ((poslednji i2) :: Int))
                         putStrLn "***********************************************"
                         let i = uvecaj i1 1 2 1
                         josI1 i i2
                  else do putStrLn "***********************************************"
                          putStr "Trenutno stanje:"
                          iscrtavanje l brojRedova 
                          putStrLn "Na potezu Igrac2."
                          poz <- unesiPoziciju l
                          br <- unesiKuglice l poz
                          nIgrac1 (zameni l br poz 1) i1 i2

{-
 rezim gomila, na potezu Igrac
-}
gIgrac brkuglica i1 i2 = if brkuglica == 0 then 
                          do putStrLn "***********************************************"
                             putStrLn "Pobednik je racunar."
                             putStrLn ("Trenutni rezultat:\nGomila: " 
                                       ++ show ((prvi i1) :: Int) 
                                       ++ "-" ++ show (((prvi i2)+1) :: Int)
                                       ++ "\nNiz: " ++ show ((poslednji i1) :: Int)
                                       ++ "-" ++ show ((poslednji i2) :: Int))
                             putStrLn "***********************************************"
                             let i = uvecaj i2 1 1 1
                             josR2 i1 i
                         else do putStrLn "***********************************************"
                                 putStrLn  "Preostalo kuglica: " 
                                 print (brkuglica) 
                                 putStrLn "Ti si na potezu."
                                 x <- unesi brkuglica
                                 gRacunar (brkuglica-x) i1 i2

{-
 rezim gomila, na potezu racunar
-}
gRacunar  brkuglica i1 i2 = if brkuglica == 0 then 
                              do putStrLn "***********************************************"
                                 putStrLn "Ti si pobednik."
                                 putStrLn ("Trenutni rezultat:\nGomila: " ++ show (((prvi i1)+1) :: Int)
                                           ++ "-" ++ show ((prvi i2) :: Int)
                                           ++"\nNiz: " ++ show ((poslednji i1) :: Int)
                                           ++ "-" ++ show ((poslednji i2) :: Int))
                                 putStrLn "***********************************************"
                                 let i = uvecaj i1 1 1 1
                                 josR1 i i2
                            else do let skini = izbor brkuglica
                                    putStrLn "***********************************************"
                                    putStrLn  "Preostalo kuglica: " 
                                    print (brkuglica) 
                                    if skini == 1 then 
					                    do putStrLn ("Na potezu racunar.\nRacunar uklanja 1 kuglicu.")
				                    else 
					                    if skini == 5 then
                                            do putStrLn ("Na potezu racunar.\nRacunar uklanja 5 kuglica.")
                                        else
                                            do putStrLn ("Na potezu racunar.\nRacunar uklanja " 
                                                         ++ show(skini :: Int) ++ " kuglice.")
                                    gIgrac (brkuglica-skini) i1 i2

{-
 rezim niz, na potezu Igrac
-}
nIgrac l i1 i2 = if (prazna l) == 1 then 
                  do putStrLn "***********************************************"
                     putStrLn "Pobednik je racunar."
                     putStrLn ("Trenutni rezultat:\nGomila: " 
                               ++ show ((prvi i1) :: Int) 
                               ++ "-" ++ show ((prvi i2) :: Int)
                               ++ "\nNiz: " ++ show ((poslednji i1) :: Int)
                               ++ "-" ++ show (((poslednji i2)+1) :: Int))
                     putStrLn "***********************************************"
                     let i = uvecaj i2 1 2 1
                     josR2 i1 i
                  else do putStrLn "***********************************************"
                          putStr "Trenutno stanje:"
                          iscrtavanje l brojRedova 
                          putStrLn "Ti si na potezu."
                          poz <- unesiPoziciju l
                          br <- unesiKuglice l poz
                          nRacunar (zameni l br poz 1) i1 i2 

{-
 rezim niz, na potezu racunar
-}                
nRacunar l i1 i2 = do if (prazna l) == 1 then 
                          do putStrLn "***********************************************"
                             putStrLn "Ti si pobednik."
                             putStrLn ("Trenutni rezultat:\nGomila: " 
                                       ++ show ((prvi i1) :: Int)
                                       ++ "-" ++ show ((prvi i2) :: Int)
                                       ++"\nNiz: " ++ show (((poslednji i1)+1) :: Int)
                                       ++ "-" ++ show ((poslednji i2) :: Int))
                             putStrLn "***********************************************"
                             let i = uvecaj i1 1 2 1
                             josR1 i i2
                      else do 
                        putStrLn "***********************************************"
                        putStr "Trenutno stanje:"
                        iscrtavanje l brojRedova
                        putStrLn "Na potezu racunar."
                        let red = izaberiRed l 0 1
                        let br = izaberiBroj l red (brojNa red l 1)
                        if br == 1 then 
		       		        do putStrLn ("Racunar uklanja 1 kuglicu iz " 
                                            ++ show(red :: Int) ++ ". reda.")
                        else 
			                if br == 5 then 
			                    do putStrLn ("Racunar uklanja 5 kuglica iz " 
                                                ++ show(red :: Int) ++ ". reda.") 
                       	    else 
			                    do putStrLn ("Racunar uklanja " ++ show(br :: Int) 
                                                ++ " kuglice iz " 
                                                ++ show(red :: Int) ++ ". reda.")
                        nIgrac (zameni l br red 1) i1 i2

{-
 funkcija za ucitavanje odabranih opcija
-}
ucitaj :: IO Int
ucitaj = do
         linija <- getLine
         return (read linija :: Int)

{-
 josI1 i josI2 pozivaju novu partiju odnosno prekidaju rad programa
 josI1 poziva se kad pobedi prvi igrac, kako bi u narednoj partiji on igrao prvi
 slicno se poziva josI2 kad pobedi drugi igrac
-}  
josI1 i1 i2 = do putStrLn "Da li zelite da nastavite sa igrom?\n1.Da\n2.Ne"
                 protivnik <- ucitaj
                 if protivnik == 1 then
                     do putStrLn "Odaberi rezim:"
                        putStrLn "1. Gomila"
                        putStrLn "2. Nizovi"
                        rezim <- ucitaj
                        igra protivnik rezim i1 i2 1
                 else 
                     do let ukupno1 = (prvi i1) + (poslednji i1)
                        let ukupno2 = (prvi i2) + (poslednji i2)
                        putStrLn ("Krajnji rezultat: " ++ show(ukupno1 :: Int) 
                                  ++ "-" ++ show(ukupno2 :: Int))
                  
josI2 i1 i2 = do putStrLn "Da li zelite da nastavite sa igrom?\n1.Da\n2.Ne"
                 protivnik <- ucitaj
                 if protivnik == 1 then
                     do putStrLn "Odaberi rezim:"
                        putStrLn "1. Gomila"
                        putStrLn "2. Nizovi"
                        rezim <- ucitaj
                        igra protivnik rezim i1 i2 2
                 else
                     do let ukupno1 = (prvi i1) + (poslednji i1)
                        let ukupno2 = (prvi i2) + (poslednji i2)
                        putStrLn ("Krajnji rezultat: " ++ show(ukupno1 :: Int) 
                                  ++ "-" ++ show(ukupno2 :: Int))

{-
 igrac bira rezim sledece partije
-}                 
josR1 i1 i2 = do putStrLn "Da li zelis da nastavis sa igrom?\n1.Da\n2.Ne"
                 opet <- ucitaj
                 if opet==1 then
                     do putStrLn "Odaberi rezim:"
                        putStrLn "1. Gomila"
                        putStrLn "2. Nizovi"
                        rezim <- ucitaj
                        let protivnik = 2
                        igra protivnik rezim i1 i2 1
                 else
                    do let ukupno1 = (prvi i1) + (poslednji i1)
                       let ukupno2 = (prvi i2) + (poslednji i2)
                       putStrLn ("Krajnji rezultat: " ++ show(ukupno1 :: Int) 
                                 ++ "-" ++ show(ukupno2 :: Int))

{-
 racunar bira rezim u kom je vise puta pobedio
-}
josR2 i1 i2 = do putStrLn "Da li zelis da nastavis sa igrom?\n1.Da\n2.Ne"
                 opet <- ucitaj
                 if opet==1 then
                     do putStrLn "Racunar bira rezim..."
                        if (prvi i2) >= (poslednji i2) then
                            do let protivnik = 2
                               let rezim = 1
                               igra protivnik rezim i1 i2 2
                        else
                            do let protivnik = 2
                               let rezim = 2
                               igra protivnik rezim i1 i2 2
                 else
                     do let ukupno1 = (prvi i1) + (poslednji i1)
                        let ukupno2 = (prvi i2) + (poslednji i2)
                        putStrLn ("Krajnji rezultat: " ++ show(ukupno1 :: Int) 
                                  ++ "-" ++ show(ukupno2 :: Int))

{-
 funkcija koja omogucava Igracu da u rezimu gomila unese broj kuglica
-}
unesi br = do putStrLn "Koliko kuglica zelis da uklonis?"
              x <- ucitaj
              if x<1 || x>3 then 
               	  do putStrLn "Nekorektan unos. Uneti broj izmedju 1 i 3."
                     unesi br
	      	  else 
		          if x>br then
	               	  do putStrLn "Na gomili nema toliko kuglica."
        	             unesi br
		          else
			          do return (broj x)

{-
 funkcija koja proverava da li su svi elementi liste jednaki 0
-} 
prazna [] = 1  
prazna (x:xs) = if x == 0 then prazna(xs)
                else 0

{-
 prvi i poslednji se koriste za liste i1 i i2 i vracaju 
 poene za gomilu odnosno za niz
-}                    
prvi (x:xs) = x

poslednji [x] = x
poslednji (x:xs) = poslednji xs 

{-
 funkcija koja uvecava jedan od elemenata liste koje cuvaju rezultate igre
-}                  
uvecaj (x:xs) a n m = if n==m then [x+a] ++ xs
                      else [x] ++ (uvecaj xs a n (m+1))

{-
 funkcija za iscrtavanje trenutnog stanja igre
-}
iscrtavanje [] b = do putChar '\n'

iscrtavanje (x:xs) b = if b /= 0 then 
                           do putStrLn "" 
                              red b
                              putChar ' '
                              unutrasnja x xs b
                       else 
                           do putStrLn ""

{-
 ispisuje broj reda
-}
red a = do let b = brojRedova - a + 1
           putChar (karakter b)

{-
 iscrtava kuglice u redu a
-}
unutrasnja a xs b = if a/=0 then do putChar 'o' 
    	                            unutrasnja (a-1) xs b
    	            else iscrtavanje xs (b-1) 

{-
 unesiKuglice i unesiPoziciju proveravaju korektnost unesenih brojeva
-}
unesiPoziciju l = do putStrLn "Iz kog reda zelis da uklonis kuglice?"
                     poz <- ucitaj
                     if poz<1 || poz>brojRedova then 
                        do putStrLn ("Nekorektan unos. Uneti broj izmedju 1 i " 
                                     ++ show(brojRedova :: Int) ++ ".")
                           unesiPoziciju l
                     else 
                        if (brojNa poz l 1)==0 then
                            do putStrLn "U odabranom redu nema vise kuglica."
                               unesiPoziciju l
                        else 
							do return (broj poz)
                        
                        
unesiKuglice l poz = do putStrLn "Koliko kuglica zelis da uklonis?"
                        br <- ucitaj
                        if (broj br) > (brojNa poz l 1) then
                            do putStrLn "U odabranom nema toliko kuglica."
                               unesiKuglice l poz
                        else 
							do return (broj br)

{-
 broj na zadatoj poziciji n menja brojem a
-}
zameni (x:xs) a n m = if n == m then [x-a] ++ xs
                      else [x] ++ (zameni xs a n (m+1))

{-
 vraca broj koji se nalazi na zadatoj poziciji
-}
brojNa pozicija (x:xs) m = if pozicija == m then x
                           else brojNa pozicija xs (m+1)

{-
 vraca Int vrednost broja koji je ucitan
-}                           
broj br 
	| br == 1 = 1
	| br == 2 = 2
	| br == 3 = 3
	| br == 4 = 4
 	| br == 5 = 5
	| br == 6 = 6
	| br == 7 = 7
	| br == 8 = 8
	| br == 9 = 9
	| otherwise = 0

{-
 vraca Char broja koji je prosledjen
-}

karakter a 
	| a == 1 = '1'
	| a == 2 = '2'
	| a == 3 = '3'
	| a == 4 = '4'
	| a == 5 = '5'
	| a == 6 = '6'
	| a == 7 = '7'
	| a == 8 = '8'
	| a == 9 = '9'
	| otherwise = '0'

{-
 racunar bira koliko ce kuglica ukloniti sa gomile
-}
izbor x 
    | x == 1 = 1
    | x == 2 = 2
    | x == 3 = 3
    | x == 5 = 1
    | x == 6 = 2
    | x == 7 = 3
    | (x `mod` 4) == 0 = 1 
    | (x `mod` 2) == 0 = 2
    | (x `mod` 2) == 1 = 3 

{-
 racunar bira red sa najvecim brojem kuglica i iz njega ce ukloniti 
 neki broj kuglica (koji odredjuje funkcijom izaberiBroj)
-}
   
izaberiRed l max p
	| (jediniPozitivan l 1 0 0) /= 0 = jediniPozitivan l 1 0 0
	| p > brojRedova = (pozicija l max 1)
	| (brojNa p l 1) > max = izaberiRed l (brojNa p l 1) (p+1)
	| otherwise = izaberiRed l max (p+1)   

{-
 racunar bira koliko kuglica ce uzeti iz reda r znajuci da ih ima b
-}    
izaberiBroj l r b = if (mod (zbir l 0) 2) == 0 then paran l r b 
                    else neparan l r b

{-
 proverava da li postoji su svi redovi osim jednog prazni
 vraca broj tog reda, ako postoji, inace 0
-}

jediniPozitivan l a b r
	| b > 1 = 0
	| a > brojRedova = r
	| (brojNa a l 1) == 0 = jediniPozitivan l (a+1) b r
	| otherwise = jediniPozitivan l (a+1) (b+1) a

{-
 racuna duzinu liste
-}
duzina [] d = d
duzina (x:xs) d = duzina xs (d+1) 

{-
 vraca poziciju u listi na kojoj se nalazi broj b
-}
pozicija [] b p = 0
pozicija (x:xs) b p = if x == b then p 
                      else pozicija xs b (p+1) 

paran l r b 
    | b==1 = 1
    | otherwise = 2

neparan l r b
    | b==1 = 1
    | b==2 = 1
    | otherwise = 3

zbir [] z = z
zbir (x:xs) z = zbir xs (z+x)
