perm(List,[H|Perm]):-del(H,List,Rest),perm(Rest,Perm).
perm([],[]).
 
del(X,[X|T],T).
del(X,[H|T],[H|NT]):-del(X,T,NT).
   
comb_rep(0,_,[]).
comb_rep(N,[X|T],[X|RComb]):-N>0,N1 is N-1,comb_rep(N1,[X|T],RComb).
comb_rep(N,[_|T],RComb):-N>0,comb_rep(N,T,RComb).
 
op('+', X1, X2, R):-R is X1 + X2.
op('-', X1, X2, R):-R is X1 - X2.
op('*', X1, X2, R):-R is X1 * X2.
op('//', X1, X2, R):-X2 =\= 0, R is X1 // X2.
   
start(Brojevi, Trazeno):-
    length(Brojevi, L),
    N is L - 1,
    forall(comb_rep(N, [+,-,*,//], Kombinacije),
    permutacije(Kombinacije, Brojevi, Trazeno)).
 
permutacije(Kombinacije, Brojevi, Trazeno):-
    append(Brojevi, Kombinacije, L),
    forall(perm(L, P), ispis(P, Trazeno)).
 
rpn([],[],_):-fail.
rpn([], [V], V).
rpn([H|T], S, V):-integer(H), rpn(T, [H|S], V).
rpn([H|T], [Hs1, Hs2 | Ts], V):-op(H,Hs2,Hs1,R), rpn(T, [R|Ts], V).
 
ispis(P, Trazeno):-rpn(P,[],Trazeno)->print_infix(P, []), false;true.
 
print_infix([], Stek):-print_list(Stek).
print_infix([H|T], Stek):- integer(H), print_infix(T, [H|Stek]).
print_infix([H|T], [Hs1, Hs2 | Ts]):-print_infix(T, [['(',Hs2, H, Hs1, ')'] | Ts]).
 
print_list(X):-
    flatten(X, Y),
    print_el(Y),
    writeln(';').
 
print_el([]).
print_el([H|T]):-write(H), print_el(T).
