/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.DBController;
import controller.Main;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.Vector;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import model.League;
import model.Player;
import model.Team;

public class ChooseTeamController
implements Initializable {
    Vector<League> leagues;
    int position_of_league_1 = 0;
    int position_of_league_2 = 1;
    int position_of_team_1 = 0;
    int position_of_team_2 = 0;
    Vector<Player> players_team_A;
    Vector<Player> players_team_B;
    @FXML
    Label lb_league1;
    @FXML
    Label lb_league2;
    @FXML
    Label lb_team1;
    @FXML
    Label lb_team2;
    @FXML
    Button bt_league1_left;
    @FXML
    Button bt_league1_right;
    @FXML
    Button bt_league2_left;
    @FXML
    Button bt_league2_right;
    @FXML
    Button bt_team1_left;
    @FXML
    Button bt_team1_right;
    @FXML
    Button bt_team2_left;
    @FXML
    Button bt_team2_right;
    @FXML
    Button bt_back;
    @FXML
    Button bt_start;
    @FXML
    Button bt_lineups_teamA;
    @FXML
    Button bt_lineups_teamB;
    @FXML
    ImageView img_league1;
    @FXML
    ImageView img_league2;
    @FXML
    ImageView img_team1;
    @FXML
    ImageView img_team2;

    private void loadLeaguesAndTeams() {
        this.leagues = new Vector();
        DBController dbController = new DBController();
        ResultSet league_query = dbController.sendQuery("select * from league");
        int num_of_leagues = 0;
        try {
            while (league_query.next()) {
                Blob league_blob = league_query.getBlob("logo");
                int league_logo_length = (int)league_blob.length();
                byte[] league_logo_bytes = league_blob.getBytes(1L, league_logo_length);
                FileOutputStream league_logo = new FileOutputStream(Main.PathToResources + league_query.getString("name") + ".png");
                league_logo.write(league_logo_bytes);
                league_logo.close();
                league_blob.free();
                Image league_image_logo = new Image(Main.URLToResources + league_query.getString("name") + ".png");
                this.leagues.add(new League(league_query.getString("name"), league_query.getInt("league_id"), league_image_logo, new Vector<Team>()));
                ++num_of_leagues;
            }
        }
        catch (SQLException e) {
            System.out.println("Failed loading leagues...");
        }
        catch (FileNotFoundException e) {
            System.out.println("failed creating league image from binary file at resources!");
        }
        catch (IOException e) {
            System.out.println("Failed writing league logo at resources!");
        }
        ResultSet result = dbController.sendQuery("select * from teams t join league l on t.league_id = l.league_id");
        try {
            while (result.next()) {
                Blob blob1 = result.getBlob("t.logo");
                int team_logo_length = (int)blob1.length();
                byte[] team_logo_bytes = blob1.getBytes(1L, team_logo_length);
                blob1.free();
                FileOutputStream team_logo = new FileOutputStream(Main.PathToResources + result.getString("t.name") + ".png");
                team_logo.write(team_logo_bytes);
                team_logo.close();
                Image team_image = new Image(Main.URLToResources + result.getString("t.name") + ".png");
                int find_me_league = result.getInt("l.league_id") - 1;
                this.leagues.get(find_me_league).getTeams().add(new Team(result.getString("t.name"), result.getInt("t.team_id"), team_image, find_me_league + 1, result.getString("l.name")));
            }
        }
        catch (SQLException e) {
            System.out.println("Crashed at ChooseTeamController while iterating through query league result!");
        }
        catch (FileNotFoundException e) {
            System.out.println("Failed creating output mapped image...");
        }
        catch (IOException e) {
            System.out.println("Failed writing bytes into memory");
        }
        dbController.cleanUp();
    }

    @FXML
    public void change_league_1_left(ActionEvent event) {
        this.position_of_league_1 = this.position_of_league_1 - 1 < 0 ? this.leagues.size() - 1 : --this.position_of_league_1;
        this.img_league1.setImage(this.leagues.get(this.position_of_league_1).getLeague_logo());
        this.position_of_team_1 = 0;
        this.lb_league1.setText(this.leagues.get(this.position_of_league_1).getLeague_name());
        this.lb_team1.setText(this.leagues.get(this.position_of_league_1).getTeams().get(this.position_of_team_1).getTeamName());
        this.img_team1.setImage(this.leagues.get(this.position_of_league_1).getTeams().get(this.position_of_team_1).getTeam_logo());
    }

    @FXML
    public void change_league_1_right(ActionEvent event) {
        this.position_of_league_1 = (this.position_of_league_1 + 1) % (this.leagues.size() - 1);
        this.img_league1.setImage(this.leagues.get(this.position_of_league_1).getLeague_logo());
        this.position_of_team_1 = 0;
        this.lb_league1.setText(this.leagues.get(this.position_of_league_1).getLeague_name());
        this.lb_team1.setText(this.leagues.get(this.position_of_league_1).getTeams().get(this.position_of_team_1).getTeamName());
        this.img_team1.setImage(this.leagues.get(this.position_of_league_1).getTeams().get(this.position_of_team_1).getTeam_logo());
    }

    @FXML
    public void change_league_2_left(ActionEvent event) {
        this.position_of_league_2 = this.position_of_league_2 - 1 < 0 ? this.leagues.size() - 1 : --this.position_of_league_2;
        this.img_league2.setImage(this.leagues.get(this.position_of_league_2).getLeague_logo());
        this.position_of_team_2 = 0;
        this.lb_league2.setText(this.leagues.get(this.position_of_league_2).getLeague_name());
        this.lb_team2.setText(this.leagues.get(this.position_of_league_2).getTeams().get(this.position_of_team_2).getTeamName());
        this.img_team2.setImage(this.leagues.get(this.position_of_league_2).getTeams().get(this.position_of_team_2).getTeam_logo());
    }

    @FXML
    public void change_league_2_right(ActionEvent event) {
        this.position_of_league_2 = (this.position_of_league_2 + 1) % (this.leagues.size() - 1);
        this.img_league2.setImage(this.leagues.get(this.position_of_league_2).getLeague_logo());
        this.position_of_team_2 = 0;
        this.lb_league2.setText(this.leagues.get(this.position_of_league_2).getLeague_name());
        this.lb_team2.setText(this.leagues.get(this.position_of_league_2).getTeams().get(this.position_of_team_2).getTeamName());
        this.img_team2.setImage(this.leagues.get(this.position_of_league_2).getTeams().get(this.position_of_team_2).getTeam_logo());
    }

    @FXML
    public void change_team_1_left(ActionEvent event) {
        this.position_of_team_1 = this.position_of_team_1 - 1 < 0 ? this.leagues.get(this.position_of_league_1).getTeams().size() - 1 : --this.position_of_team_1;
        this.lb_team1.setText(this.leagues.get(this.position_of_league_1).getTeams().get(this.position_of_team_1).getTeamName());
        this.img_team1.setImage(this.leagues.get(this.position_of_league_1).getTeams().get(this.position_of_team_1).getTeam_logo());
    }

    @FXML
    public void change_team_1_right(ActionEvent event) {
        int num_of_teams = this.leagues.get(this.position_of_league_1).getTeams().size();
        this.position_of_team_1 = (this.position_of_team_1 + 1) % num_of_teams;
        this.lb_team1.setText(this.leagues.get(this.position_of_league_1).getTeams().get(this.position_of_team_1).getTeamName());
        this.img_team1.setImage(this.leagues.get(this.position_of_league_1).getTeams().get(this.position_of_team_1).getTeam_logo());
    }

    @FXML
    public void change_team_2_left(ActionEvent event) {
        this.position_of_team_2 = this.position_of_team_2 - 1 < 0 ? this.leagues.get(this.position_of_league_2).getTeams().size() - 1 : --this.position_of_team_2;
        this.lb_team2.setText(this.leagues.get(this.position_of_league_2).getTeams().get(this.position_of_team_2).getTeamName());
        this.img_team2.setImage(this.leagues.get(this.position_of_league_2).getTeams().get(this.position_of_team_2).getTeam_logo());
    }

    @FXML
    public void change_team_2_right(ActionEvent event) {
        int num_of_teams = this.leagues.get(this.position_of_league_2).getTeams().size();
        this.position_of_team_2 = (this.position_of_team_2 + 1) % num_of_teams;
        this.lb_team2.setText(this.leagues.get(this.position_of_league_2).getTeams().get(this.position_of_team_2).getTeamName());
        this.img_team2.setImage(this.leagues.get(this.position_of_league_2).getTeams().get(this.position_of_team_2).getTeam_logo());
    }

    @FXML
    public void go_to_lineups_teamA(ActionEvent event) throws IOException {
        Main.lineupsChosenTeam = 1;
        Main.InitialChosenLeague1 = this.position_of_league_1;
        Main.InitialChosenLeague2 = this.position_of_league_2;
        Main.InitialChosenTeam1 = this.position_of_team_1;
        Main.InitialChosenTeam2 = this.position_of_team_2;
        this.setChosenTeams();
        Stage stage = (Stage)this.bt_lineups_teamA.getScene().getWindow();
        Parent root = (Parent)FXMLLoader.load((URL)new URL(Main.PathToViews + "/Lineups.fxml"));
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.show();
    }

    @FXML
    public void go_to_lineups_teamB(ActionEvent event) throws IOException {
        Main.lineupsChosenTeam = 2;
        Main.InitialChosenLeague1 = this.position_of_league_1;
        Main.InitialChosenLeague2 = this.position_of_league_2;
        Main.InitialChosenTeam1 = this.position_of_team_1;
        Main.InitialChosenTeam2 = this.position_of_team_2;
        this.setChosenTeams();
        Stage stage = (Stage)this.bt_lineups_teamB.getScene().getWindow();
        Parent root = (Parent)FXMLLoader.load((URL)new URL(Main.PathToViews + "/Lineups.fxml"));
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.show();
    }

    @FXML
    public void go_to_main_screen(ActionEvent event) throws IOException {
        Stage stage = (Stage)this.bt_back.getScene().getWindow();
        Parent root = (Parent)FXMLLoader.load((URL)new URL(Main.PathToViews + "/MainScreen.fxml"));
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.show();
    }

    private void setChosenTeams() {
        DBController query = new DBController();
        String query1 = "select * from players  p join players_stats ps on p.player_id = ps.player_id ";
        query1 = query1 + "join teams t on t.team_id = p.team_id ";
        query1 = query1 + "join league l on l.league_id = t.league_id where t.name ='" + this.lb_team1.getText() + "'";
        String query2 = "select * from players  p join players_stats ps on p.player_id = ps.player_id ";
        query2 = query2 + "join teams t on t.team_id = p.team_id ";
        query2 = query2 + "join league l on l.league_id = t.league_id where t.name ='" + this.lb_team2.getText() + "'";
        ResultSet players_team_1 = query.sendQuery(query1);
        ResultSet players_team_2 = query.sendQuery(query2);
        this.players_team_A = new Vector();
        this.players_team_B = new Vector();
        int i = 0;
        try {
            while (players_team_1.next()) {
                this.players_team_A.add(i++, new Player(players_team_1));
            }
            i = 0;
            while (players_team_2.next()) {
                this.players_team_B.add(i++, new Player(players_team_2));
            }
        }
        catch (SQLException e) {
            System.out.println("Sql exp simulation controller");
        }
        query1 = "select * from players p join players_stats ps on p.player_id = ps.player_id ";
        query1 = query1 + "join teams t on t.team_id = p.team_id ";
        query1 = query1 + "join league l on l.league_id = t.league_id where t.name ='" + this.lb_team1.getText() + "'";
        query2 = "select * from players p join players_stats ps on p.player_id = ps.player_id ";
        query2 = query2 + "join teams t on t.team_id = p.team_id ";
        query2 = query2 + "join league l on l.league_id = t.league_id where t.name ='" + this.lb_team2.getText() + "'";
        players_team_1 = query.sendQuery(query1);
        players_team_2 = query.sendQuery(query2);
        try {
            while (players_team_1.next()) {
                Main.teamA = new Team(this.lb_team1.getText(), players_team_1.getInt("t.team_id"), players_team_1.getInt("l.league_id"), players_team_1.getString("l.name"), this.players_team_A);
                Main.teamA.setTeam_logo(new Image(Main.URLToResources + Main.teamA.getTeamName() + ".png"));
            }
            while (players_team_2.next()) {
                Main.teamB = new Team(this.lb_team2.getText(), players_team_2.getInt("t.team_id"), players_team_2.getInt("l.league_id"), players_team_2.getString("l.name"), this.players_team_B);
                Main.teamB.setTeam_logo(new Image(Main.URLToResources + Main.teamB.getTeamName() + ".png"));
            }
        }
        catch (SQLException e) {
            System.out.println("Globalni objekat team FAIL");
        }
        query.cleanUp();
    }

    @FXML
    public void go_to_simulation(ActionEvent event) throws IOException {
        this.setChosenTeams();
        Stage stage = (Stage)this.bt_back.getScene().getWindow();
        Parent root = (Parent)FXMLLoader.load((URL)new URL(Main.PathToViews + "/Simulation.fxml"));
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.show();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.loadLeaguesAndTeams();
        this.img_league1.setImage(this.leagues.get(Main.InitialChosenLeague1).getLeague_logo());
        this.img_league2.setImage(this.leagues.get(Main.InitialChosenLeague2).getLeague_logo());
        this.img_team1.setImage(this.leagues.get(Main.InitialChosenLeague1).getTeams().get(Main.InitialChosenTeam1).getTeam_logo());
        this.img_team2.setImage(this.leagues.get(Main.InitialChosenLeague2).getTeams().get(Main.InitialChosenTeam2).getTeam_logo());
        this.lb_league1.setText(this.leagues.get(Main.InitialChosenLeague1).getLeague_name());
        this.lb_league2.setText(this.leagues.get(Main.InitialChosenLeague2).getLeague_name());
        this.lb_team1.setText(this.leagues.get(Main.InitialChosenLeague1).getTeams().get(Main.InitialChosenTeam1).getTeamName());
        this.lb_team2.setText(this.leagues.get(Main.InitialChosenLeague2).getTeams().get(Main.InitialChosenTeam2).getTeamName());
        this.setChosenTeams();
    }
}

