/*
 * Decompiled with CFR 0.152.
 */
package controller;

import java.util.Random;
import model.Player;

public class DuelsEvaluator {
    private Random rand = new Random();
    public static float failedEvent = 0.1f;
    public static float successfulEvent = 0.9f;
    float passingInitialSuccessPenalty = 0.8f;
    float passingAfterSuccInterceptPenalty = 0.5f;
    float passingAfterFailInterceptPenalty = 0.8f;
    float dribblingInitialSucessPenalty = 0.6f;
    float dribblingAfterSuccTacklePenalty = 0.3f;
    float dribblingAfterFailTacklePenalty = 0.8f;
    float cornerPenalty = 0.2f;
    float throwInPenalty = 0.75f;
    float ShootingInitialPenalty = 0.4f;
    float ShootingSuccessfulShotPenalty = 0.4f;
    float ShootingFailedShotPenalty = 0.9f;
    public static String CommentaryMsg;
    private Player lastScorer;

    public Player getLastKnownScorer() {
        return this.lastScorer;
    }

    public void setLastScorer(Player lastScorer) {
        this.lastScorer = lastScorer;
    }

    private float toProb(int val) {
        return (float)val * 1.0f / 100.0f;
    }

    private void logEvent(String msg, float eventResult) {
        msg = eventResult == successfulEvent ? msg + " SUCCESS!" : msg + " FAILED!";
        System.out.println(msg);
        System.out.println();
    }

    public float tryPassing(Player passer, Player opposition) {
        float eventResult;
        int shortPassing = passer.getStats().get("low_pass");
        int longPassing = passer.getStats().get("lofted_pass");
        int defensiveProwess = opposition.getStats().get("defensive_prowess");
        int ballWinning = opposition.getStats().get("ball_winning");
        float dragon = this.rand.nextFloat();
        float probNoPressure = 0.5f;
        boolean shortPass = true;
        if (dragon <= probNoPressure) {
            dragon = this.rand.nextFloat();
            if (dragon <= 0.7f) {
                dragon = this.rand.nextFloat();
                eventResult = dragon <= this.toProb(shortPassing) ? successfulEvent : ((dragon = this.rand.nextFloat()) <= this.toProb(shortPassing) ? successfulEvent : failedEvent);
            } else {
                eventResult = dragon <= this.toProb(longPassing) ? successfulEvent : failedEvent;
                shortPass = false;
            }
            if (eventResult == successfulEvent) {
                CommentaryMsg = passer.getFullPlayerName() + " sends a ";
                CommentaryMsg = shortPass ? CommentaryMsg + "short" : CommentaryMsg + "long";
                CommentaryMsg = CommentaryMsg + " pass to a teammate.";
            } else {
                CommentaryMsg = passer.getFullPlayerName() + " with an unforced error. ";
                CommentaryMsg = CommentaryMsg + opposition.getFullPlayerName() + " takes the ball for his team.";
            }
        } else if (dragon <= (this.toProb(shortPassing) + this.toProb(longPassing)) / 2.0f * this.passingInitialSuccessPenalty) {
            dragon = this.rand.nextFloat();
            if (dragon <= (this.toProb(defensiveProwess) + this.toProb(ballWinning)) / 2.0f * this.passingAfterSuccInterceptPenalty) {
                eventResult = failedEvent;
                CommentaryMsg = opposition.getFullPlayerName() + " with a great interception of the pass";
                CommentaryMsg = CommentaryMsg + " sent by " + passer.getFullPlayerName();
            } else {
                eventResult = successfulEvent;
                CommentaryMsg = passer.getFullPlayerName() + " with a pass for a teammate.";
            }
        } else {
            dragon = this.rand.nextFloat();
            eventResult = dragon <= (this.toProb(defensiveProwess) + this.toProb(ballWinning)) / 2.0f * this.passingAfterFailInterceptPenalty ? failedEvent : successfulEvent;
        }
        this.logEvent("PASSING:", eventResult);
        return eventResult;
    }

    public float tryDribbling(Player dribbler, Player opposition) {
        int dribbling = dribbler.getStats().get("dribbling");
        int speed = dribbler.getStats().get("speed");
        int explosivePower = dribbler.getStats().get("explosive_power");
        int ballWinning = opposition.getStats().get("ball_winning");
        int bodyBalance = opposition.getStats().get("body_balance");
        int defensiveProwess = opposition.getStats().get("defensive_prowess");
        float dragon = this.rand.nextFloat();
        float eventResult = dragon <= (this.toProb(dribbling) + this.toProb(speed) + this.toProb(explosivePower)) / 3.0f * this.dribblingInitialSucessPenalty ? ((dragon = this.rand.nextFloat()) <= (this.toProb(bodyBalance) + this.toProb(defensiveProwess) + this.toProb(ballWinning)) / 3.0f * this.dribblingAfterSuccTacklePenalty ? failedEvent : successfulEvent) : ((dragon = this.rand.nextFloat()) <= (this.toProb(bodyBalance) + this.toProb(defensiveProwess) + this.toProb(ballWinning)) / 3.0f * this.dribblingAfterFailTacklePenalty ? failedEvent : successfulEvent);
        this.logEvent("SHOOTING : ", eventResult);
        CommentaryMsg = eventResult == successfulEvent ? dribbler.getFullPlayerName() + " dribbles past " + opposition.getFullPlayerName() : dribbler.getFullPlayerName() + " tries to dribble, but, " + opposition.getFullPlayerName() + " takes the ball away.";
        return eventResult;
    }

    public float tryCorner(Player taker) {
        int placeKicking = taker.getStats().get("place_kicking");
        float dragon = this.rand.nextFloat();
        float eventResult = dragon <= this.toProb(placeKicking) * this.cornerPenalty ? successfulEvent : failedEvent;
        this.logEvent("CORNER: ", eventResult);
        CommentaryMsg = eventResult == successfulEvent ? taker.getFullPlayerName() + " with a great corner, and their team scores!" : taker.getFullPlayerName() + " takes the corner, but opposition defends well.";
        return eventResult;
    }

    public float tryThrowIn() {
        float dragon = this.rand.nextFloat();
        float eventResult = dragon <= this.throwInPenalty ? successfulEvent : failedEvent;
        this.logEvent("THROW IN: ", eventResult);
        return eventResult;
    }

    public float dummyFunction() {
        float dragon = this.rand.nextFloat();
        if ((double)dragon <= 0.5) {
            return successfulEvent;
        }
        return failedEvent;
    }

    public String toString() {
        return "Hello world, I am used to simulate events in a football game.";
    }

    public float tryShooting(Player shooter, Player goalkeeper) {
        float eventResult;
        int attackingProwess = shooter.getStats().get("attacking_prowess");
        int finishing = shooter.getStats().get("finishing");
        int kickingPower = shooter.getStats().get("kicking_power");
        int gkOverall = goalkeeper.getStats().get("overall");
        float avg = (this.toProb(attackingProwess) + this.toProb(kickingPower) + this.toProb(finishing)) / 3.0f;
        float dragon = this.rand.nextFloat();
        if (dragon <= avg * this.ShootingInitialPenalty) {
            dragon = this.rand.nextFloat();
            if (dragon <= this.toProb(gkOverall) * this.ShootingSuccessfulShotPenalty) {
                eventResult = failedEvent;
            } else {
                eventResult = successfulEvent;
                this.setLastScorer(shooter);
            }
        } else {
            dragon = this.rand.nextFloat();
            if (dragon <= this.toProb(gkOverall) * this.ShootingFailedShotPenalty) {
                eventResult = failedEvent;
            } else {
                eventResult = successfulEvent;
                this.setLastScorer(shooter);
            }
        }
        CommentaryMsg = eventResult == successfulEvent ? shooter.getFullPlayerName() + " with a shot...and he scores!" : shooter.getFullPlayerName() + " takes a shot, but GK saves!";
        return eventResult;
    }
}

