/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.Main;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import model.GameAutomaton;
import model.Team;

public class SimulationController
extends Thread
implements Initializable {
    Team teamA;
    Team teamB;
    GameAutomaton gameAutomaton;
    SimpleStringProperty team1Name;
    SimpleStringProperty team2Name;
    @FXML
    Label lb_team1;
    @FXML
    Label lb_team2;
    @FXML
    Label lb_minute;
    @FXML
    ImageView img_team1;
    @FXML
    ImageView img_team2;
    @FXML
    Label lb_goals_team1;
    @FXML
    Label lb_goals_team2;
    @FXML
    Label lb_poss_team1;
    @FXML
    Label lb_poss_team2;
    @FXML
    Label lb_shots_off_target_team1;
    @FXML
    Label lb_shots_off_target_team2;
    @FXML
    Label lb_shots_on_target_team1;
    @FXML
    Label lb_shots_on_target_team2;
    @FXML
    Label lb_attempted_passes_team1;
    @FXML
    Label lb_attempted_passes_team2;
    @FXML
    Label lb_successful_passes_team1;
    @FXML
    Label lb_successful_passes_team2;
    @FXML
    Label lb_tackles_team1;
    @FXML
    Label lb_tackles_team2;
    @FXML
    Label lb_fouls_team1;
    @FXML
    Label lb_fouls_team2;
    @FXML
    Label lb_interceptions_team1;
    @FXML
    Label lb_interceptions_team2;
    @FXML
    Label lb_corners_team1;
    @FXML
    Label lb_corners_team2;
    @FXML
    TextArea ta_commentary;
    @FXML
    TextArea ta_scorers;
    @FXML
    Button bt_home;

    public void initialize(URL location, ResourceBundle resources) {
        this.teamA = Main.teamA;
        this.teamB = Main.teamB;
        this.gameAutomaton = new GameAutomaton(this.teamA, this.teamB);
        this.bindGuiElements(this.gameAutomaton);
        this.ta_commentary.setText("Welcome to Project Aurora.\n");
        this.ta_commentary.appendText("Playing today: " + this.teamA.getTeamName() + " versus " + this.teamB.getTeamName() + "\n");
        this.ta_commentary.appendText("Starting from the center of the pitch: " + this.teamA.getTeamName() + "\n");
        this.gameAutomaton.start();
    }

    @FXML
    private void bt_homeAction(ActionEvent event) throws IOException {
        this.gameAutomaton.interrupt();
        this.gameAutomaton = null;
        Stage stage = (Stage)this.bt_home.getScene().getWindow();
        Parent root = (Parent)FXMLLoader.load((URL)new URL(Main.PathToViews + "/MainScreen.fxml"));
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.show();
    }

    private void bindGuiElements(GameAutomaton gameAutomaton) {
        this.team1Name = new SimpleStringProperty(this.teamA.getTeamName());
        this.team2Name = new SimpleStringProperty(this.teamB.getTeamName());
        this.lb_team1.textProperty().bind((ObservableValue)this.team1Name);
        this.lb_team2.textProperty().bind((ObservableValue)this.team2Name);
        this.img_team1.setImage(this.teamA.getTeam_logo());
        this.img_team2.setImage(this.teamB.getTeam_logo());
        gameAutomaton.initLabels(this.lb_goals_team1, this.lb_goals_team2, this.lb_poss_team1, this.lb_poss_team2, this.lb_shots_off_target_team1, this.lb_shots_off_target_team2, this.lb_shots_on_target_team1, this.lb_shots_on_target_team2, this.lb_attempted_passes_team1, this.lb_attempted_passes_team2, this.lb_successful_passes_team1, this.lb_successful_passes_team2, this.lb_tackles_team1, this.lb_tackles_team2, this.lb_fouls_team1, this.lb_fouls_team2, this.lb_interceptions_team1, this.lb_interceptions_team2, this.lb_minute, this.lb_corners_team1, this.lb_corners_team2);
        gameAutomaton.bindCommentaryBox(this.ta_commentary);
        gameAutomaton.bindListViewsScorers(this.ta_scorers);
    }
}

